/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.pd.PBoxPDResources;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXForm;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXImage;
import org.verapdf.model.pdlayer.PDXObject;

public class PBoxPDXObject
extends PBoxPDResources
implements PDXObject {
    public static final Logger logger = Logger.getLogger(PBoxPDXObject.class);
    public static final String OPI = "OPI";
    public static final String S_MASK = "SMask";
    public static final Integer MAX_NUMBER_OF_ELEMENTS = 1;

    public PBoxPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject simplePDObject) {
        super((COSObjectable)simplePDObject);
        this.setType("PDXObject");
    }

    public String getSubtype() {
        COSStream dict = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
        return this.getSubtypeString(dict.getItem(COSName.SUBTYPE));
    }

    protected String getSubtypeString(COSBase item) {
        if (item instanceof COSString) {
            return ((COSString)item).getString();
        }
        if (item instanceof COSName) {
            return ((COSName)item).getName();
        }
        if (item instanceof COSObject) {
            return this.getSubtypeString(((COSObject)item).getObject());
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "SMask": {
                list = this.getSMask();
                break;
            }
            case "OPI": {
                list = this.getOPI();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<PDXObject> getSMask() {
        ArrayList<PDXObject> mask = new ArrayList<PDXObject>(MAX_NUMBER_OF_ELEMENTS);
        try {
            PDXObject xObject;
            COSStream cosStream = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
            COSBase smaskDictionary = cosStream.getDictionaryObject(COSName.SMASK);
            if (smaskDictionary instanceof COSDictionary && (xObject = this.getXObject(smaskDictionary)) != null) {
                mask.add(xObject);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Problems with obtaining SMask. " + e.getMessage()));
        }
        return mask;
    }

    private PDXObject getXObject(COSBase smaskDictionary) throws IOException {
        COSName name = ((COSDictionary)smaskDictionary).getCOSName(COSName.NAME);
        String nameAsString = name != null ? name.getName() : null;
        PDResources resources = null;
        if (this.simplePDObject instanceof PDFormXObject) {
            resources = ((PDFormXObject)this.simplePDObject).getResources();
        }
        org.apache.pdfbox.pdmodel.graphics.PDXObject pbObject = org.apache.pdfbox.pdmodel.graphics.PDXObject.createXObject((COSBase)smaskDictionary, (String)nameAsString, resources);
        return this.getTypedPDXObject(pbObject);
    }

    private PDXObject getTypedPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject pbObject) {
        if (pbObject instanceof PDFormXObject) {
            return new PBoxPDXForm((PDFormXObject)pbObject);
        }
        if (pbObject instanceof PDImageXObject) {
            return new PBoxPDXImage((PDImageXObject)pbObject);
        }
        if (pbObject instanceof PDPostScriptXObject) {
            return new PBoxPDXObject(pbObject);
        }
        return null;
    }

    private List<CosDict> getOPI() {
        return this.getLinkToDictionary(OPI);
    }

    protected List<CosDict> getLinkToDictionary(String key) {
        COSDictionary itemDictionary;
        ArrayList<CosDict> list = new ArrayList<CosDict>(MAX_NUMBER_OF_ELEMENTS);
        COSStream object = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
        COSBase item = object.getItem(COSName.getPDFName((String)key));
        if (item != null && (itemDictionary = this.getDictionary(item)) != null) {
            list.add(new PBCosDict(itemDictionary));
        }
        return list;
    }

    protected COSDictionary getDictionary(COSBase item) {
        if (item instanceof COSDictionary) {
            return (COSDictionary)item;
        }
        if (item instanceof COSObject) {
            return this.getDictionary(((COSObject)item).getObject());
        }
        return null;
    }
}

