/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.external;

import org.apache.log4j.Logger;
import org.verapdf.model.external.ICCProfile;
import org.verapdf.model.impl.pb.external.PBoxExternal;

public class PBoxICCProfile
extends PBoxExternal
implements ICCProfile {
    public static final Logger logger = Logger.getLogger(PBoxICCProfile.class);
    public static final Integer DEVICE_CLASS_OFFSET = 12;
    public static final Integer COLOR_SPACE_OFFSET = 16;
    public static final Integer REQUIRED_LENGTH = 4;
    private byte[] profile;
    private Long N;

    public byte[] getProfile() {
        return this.profile;
    }

    protected PBoxICCProfile(byte[] profile, Long N) {
        this.profile = new byte[profile.length];
        System.arraycopy(profile, 0, this.profile, 0, profile.length);
        this.N = N;
    }

    public String getdeviceClass() {
        return this.getSubArray(DEVICE_CLASS_OFFSET, REQUIRED_LENGTH);
    }

    public Long getN() {
        return this.N;
    }

    public String getcolorSpace() {
        return this.getSubArray(COLOR_SPACE_OFFSET, REQUIRED_LENGTH);
    }

    private String getSubArray(Integer start, Integer length) {
        if (start + length <= this.profile.length) {
            byte[] buffer = new byte[length.intValue()];
            System.arraycopy(this.profile, start, buffer, 0, length);
            return new String(buffer);
        }
        logger.error((Object)("Length of icc profile less than " + (start + length)));
        return null;
    }

    public Double getversion() {
        Integer subversionByte = 9;
        if (this.profile.length > subversionByte) {
            Integer versionLength = 3;
            Integer vesrsionByte = 8;
            StringBuilder version = new StringBuilder(versionLength);
            version.append(this.profile[vesrsionByte]).append('.');
            version.append(this.profile[subversionByte] >>> REQUIRED_LENGTH);
            return Double.valueOf(version.toString());
        }
        logger.error((Object)"ICC profile contain less than 10 bytes of data.");
        return -1.0;
    }

    public Boolean getisValid() {
        return Boolean.TRUE;
    }
}

