/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosName;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.pd.PBoxPDMetadata;
import org.verapdf.model.pdlayer.PDMetadata;

public class PBCosDict
extends PBCosObject
implements CosDict {
    public static final String KEYS = "keys";
    public static final String VALUES = "values";
    public static final String METADATA = "metadata";

    public PBCosDict(COSDictionary dictionary) {
        super((COSBase)dictionary);
        this.setType("CosDict");
    }

    public Long getsize() {
        return ((COSDictionary)this.baseObject).size();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "keys": {
                list = this.getKeys();
                break;
            }
            case "values": {
                list = this.getValues();
                break;
            }
            case "metadata": {
                list = this.getMetadata();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<CosName> getKeys() {
        ArrayList<CosName> list = new ArrayList<CosName>(this.getsize().intValue());
        for (COSName key : ((COSDictionary)this.baseObject).keySet()) {
            if (key == null) continue;
            list.add((CosName)PBCosDict.getFromValue((COSBase)key));
        }
        return list;
    }

    private List<CosObject> getValues() {
        ArrayList<CosObject> list = new ArrayList<CosObject>(this.getsize().intValue());
        for (COSBase value : ((COSDictionary)this.baseObject).getValues()) {
            if (value == null) continue;
            list.add(PBCosDict.getFromValue(value));
        }
        return list;
    }

    private List<PDMetadata> getMetadata() {
        ArrayList<PDMetadata> pdMetadatas = new ArrayList<PDMetadata>(1);
        COSBase meta = ((COSDictionary)this.baseObject).getDictionaryObject(COSName.METADATA);
        COSName type = ((COSDictionary)this.baseObject).getCOSName(COSName.TYPE);
        if (meta != null && meta instanceof COSStream && type != COSName.CATALOG) {
            org.apache.pdfbox.pdmodel.common.PDMetadata metadata = new org.apache.pdfbox.pdmodel.common.PDMetadata((COSStream)meta);
            pdMetadatas.add(new PBoxPDMetadata(metadata, Boolean.FALSE));
        }
        return pdMetadatas;
    }
}

