/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingIntent;
import org.verapdf.model.factory.operator.GraphicState;
import org.verapdf.model.impl.pb.operator.color.PBOpColor;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_J_line_cap;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_M_miter_limit;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_d;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_gs;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_i;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_j_line_join;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_ri;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_w_line_width;
import org.verapdf.model.impl.pb.operator.inlineimage.PBOpInlineImage;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_BDC;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_BMC;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_DP;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_EMC;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_MP;
import org.verapdf.model.impl.pb.operator.opclip.PBOp_WStar;
import org.verapdf.model.impl.pb.operator.opclip.PBOp_W_clip;
import org.verapdf.model.impl.pb.operator.opcompability.PBOp_BX;
import org.verapdf.model.impl.pb.operator.opcompability.PBOp_EX;
import org.verapdf.model.impl.pb.operator.opcompability.PBOp_Undefined;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_c;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_h;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_l;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_m_moveto;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_re;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_v;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_y;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_BStar_eofill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_B_fill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_FStar;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_F_fill_obsolete;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_S_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_b_closepath_fill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_bstar_closepath_eofill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_f_fill;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_n;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_s_close_stroke;
import org.verapdf.model.impl.pb.operator.shading.PBOp_sh;
import org.verapdf.model.impl.pb.operator.specialgs.PBOp_Q_grestore;
import org.verapdf.model.impl.pb.operator.specialgs.PBOp_cm;
import org.verapdf.model.impl.pb.operator.specialgs.PBOp_q_gsave;
import org.verapdf.model.impl.pb.operator.textobject.PBOpTextObject;
import org.verapdf.model.impl.pb.operator.textposition.PBOpTextPosition;
import org.verapdf.model.impl.pb.operator.textposition.PBOp_TD_Big;
import org.verapdf.model.impl.pb.operator.textposition.PBOp_Td;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_DoubleQuote;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_Quote;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_TJ_Big;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_Tj;
import org.verapdf.model.impl.pb.operator.textstate.PBOpTextState;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Tz;
import org.verapdf.model.impl.pb.operator.type3font.PBOpType3Font;
import org.verapdf.model.impl.pb.operator.xobject.PBOp_Do;
import org.verapdf.model.operator.Operator;

public final class OperatorFactory {
    public static final Logger logger = Logger.getLogger(OperatorFactory.class);

    public static Operator parseOperator(org.apache.pdfbox.contentstream.operator.Operator pdfBoxOperator, PDResources resources, List<COSBase> arguments, Stack<GraphicState> graphicStateStack, GraphicState graphicState) {
        String operatorName;
        switch (operatorName = pdfBoxOperator.getName()) {
            case "d": {
                return new PBOp_d(arguments);
            }
            case "gs": {
                return new PBOp_gs(arguments, OperatorFactory.getExtGStateFromResources(resources, OperatorFactory.getLastElement(arguments)));
            }
            case "i": {
                return new PBOp_i(arguments);
            }
            case "J": {
                return new PBOp_J_line_cap(arguments);
            }
            case "j": {
                return new PBOp_j_line_join(arguments);
            }
            case "M": {
                return new PBOp_M_miter_limit(arguments);
            }
            case "ri": {
                return new PBOp_ri(arguments);
            }
            case "W": {
                return new PBOp_w_line_width(arguments);
            }
            case "BMC": {
                return new PBOp_BMC(arguments);
            }
            case "BDC": {
                return new PBOp_BDC(arguments);
            }
            case "EMC": {
                return new PBOp_EMC(arguments);
            }
            case "MP": {
                return new PBOp_MP(arguments);
            }
            case "DP": {
                return new PBOp_DP(arguments);
            }
            case "w": {
                return new PBOp_W_clip(arguments);
            }
            case "W*": {
                return new PBOp_WStar(arguments);
            }
            case "G": {
                graphicState.setStrokeColorSpace((PDColorSpace)PDDeviceGray.INSTANCE);
                return new PBOpColor(arguments);
            }
            case "g": {
                graphicState.setFillColorSpace((PDColorSpace)PDDeviceGray.INSTANCE);
                return new PBOpColor(arguments);
            }
            case "RG": {
                graphicState.setStrokeColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
                return new PBOpColor(arguments);
            }
            case "rg": {
                graphicState.setFillColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
                return new PBOpColor(arguments);
            }
            case "K": {
                return new PBOpColor(arguments);
            }
            case "k": {
                graphicState.setFillColorSpace((PDColorSpace)PDDeviceCMYK.INSTANCE);
                return new PBOpColor(arguments);
            }
            case "CS": {
                graphicState.setStrokeColorSpace(OperatorFactory.getColorSpaceFromResources(resources, OperatorFactory.getLastElement(arguments)));
                return new PBOpColor(arguments);
            }
            case "cs": {
                graphicState.setFillColorSpace(OperatorFactory.getColorSpaceFromResources(resources, OperatorFactory.getLastElement(arguments)));
                return new PBOpColor(arguments);
            }
            case "SCN": {
                return new PBOpColor(arguments);
            }
            case "scn": {
                return new PBOpColor(arguments);
            }
            case "SC": {
                return new PBOpColor(arguments);
            }
            case "sc": {
                return new PBOpColor(arguments);
            }
            case "ET": 
            case "BT": {
                return new PBOpTextObject(arguments);
            }
            case "Td": {
                return new PBOp_Td(arguments);
            }
            case "TD": {
                return new PBOp_TD_Big(arguments);
            }
            case "Tm": 
            case "T*": {
                return new PBOpTextPosition(arguments);
            }
            case "Tj": {
                return new PBOp_Tj(arguments);
            }
            case "TJ": {
                return new PBOp_TJ_Big(arguments);
            }
            case "'": {
                return new PBOp_Quote(arguments);
            }
            case "\"": {
                return new PBOp_DoubleQuote(arguments);
            }
            case "Tz": {
                return new PBOp_Tz(arguments);
            }
            case "Tc": 
            case "Tw": 
            case "TL": 
            case "Tf": 
            case "Tr": 
            case "Ts": {
                return new PBOpTextState(arguments);
            }
            case "d0": 
            case "d1": {
                return new PBOpType3Font(arguments);
            }
            case "BI": 
            case "ID": 
            case "EI": {
                arguments.add((COSBase)pdfBoxOperator.getImageParameters());
                return new PBOpInlineImage(arguments);
            }
            case "BX": {
                return new PBOp_BX(arguments);
            }
            case "EX": {
                return new PBOp_EX(arguments);
            }
            case "c": {
                return new PBOp_c(arguments);
            }
            case "h": {
                return new PBOp_h(arguments);
            }
            case "l": {
                return new PBOp_l(arguments);
            }
            case "m": {
                return new PBOp_m_moveto(arguments);
            }
            case "re": {
                return new PBOp_re(arguments);
            }
            case "v": {
                return new PBOp_v(arguments);
            }
            case "y": {
                return new PBOp_y(arguments);
            }
            case "b": {
                return new PBOp_b_closepath_fill_stroke(arguments, graphicState.getStrokeColorSpace(), graphicState.getFillColorSpace());
            }
            case "B": {
                return new PBOp_B_fill_stroke(arguments, graphicState.getStrokeColorSpace(), graphicState.getFillColorSpace());
            }
            case "b*": {
                return new PBOp_bstar_closepath_eofill_stroke(arguments, graphicState.getStrokeColorSpace(), graphicState.getFillColorSpace());
            }
            case "B*": {
                return new PBOp_BStar_eofill_stroke(arguments, graphicState.getStrokeColorSpace(), graphicState.getFillColorSpace());
            }
            case "f": {
                return new PBOp_f_fill(arguments, graphicState.getFillColorSpace());
            }
            case "F": {
                return new PBOp_F_fill_obsolete(arguments, graphicState.getFillColorSpace());
            }
            case "f*": {
                return new PBOp_FStar(arguments, graphicState.getFillColorSpace());
            }
            case "n": {
                return new PBOp_n(arguments);
            }
            case "s": {
                return new PBOp_s_close_stroke(arguments, graphicState.getStrokeColorSpace());
            }
            case "S": {
                return new PBOp_S_stroke(arguments, graphicState.getStrokeColorSpace());
            }
            case "sh": {
                return new PBOp_sh(arguments, OperatorFactory.getShadingFromResources(resources, OperatorFactory.getLastElement(arguments)));
            }
            case "cm": {
                return new PBOp_cm(arguments);
            }
            case "Q": {
                graphicState.copyProperties(graphicStateStack.pop());
                return new PBOp_Q_grestore(arguments);
            }
            case "q": {
                graphicStateStack.push(graphicState.clone());
                return new PBOp_q_gsave(arguments, graphicStateStack.size());
            }
            case "Do": {
                return new PBOp_Do(arguments, OperatorFactory.getXObjectFromResources(resources, OperatorFactory.getLastElement(arguments)));
            }
        }
        return new PBOp_Undefined(arguments);
    }

    public static List<Operator> parseOperators(List<Object> pdfBoxTokens, PDResources resources) {
        Stack<GraphicState> graphicStateStack = new Stack<GraphicState>();
        return OperatorFactory.parseOperators(pdfBoxTokens.iterator(), resources, graphicStateStack);
    }

    private static List<Operator> parseOperators(Iterator<Object> pdfBoxTokens, PDResources resources, Stack<GraphicState> graphicStateStack) {
        ArrayList<Operator> result = new ArrayList<Operator>();
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        GraphicState graphicState = new GraphicState();
        while (pdfBoxTokens.hasNext()) {
            Object pdfBoxToken = pdfBoxTokens.next();
            if (pdfBoxToken instanceof COSBase) {
                arguments.add((COSBase)pdfBoxToken);
                continue;
            }
            if (pdfBoxToken instanceof org.apache.pdfbox.contentstream.operator.Operator) {
                result.add(OperatorFactory.parseOperator((org.apache.pdfbox.contentstream.operator.Operator)pdfBoxToken, resources, arguments, graphicStateStack, graphicState));
                arguments.clear();
                continue;
            }
            if (pdfBoxToken instanceof RenderingIntent) {
                String value = ((RenderingIntent)pdfBoxToken).stringValue();
                arguments.add((COSBase)COSName.getPDFName((String)value));
                continue;
            }
            logger.error((Object)("Unexpected type of object in tokens: " + pdfBoxToken.getClass().getName()));
        }
        return result;
    }

    private static COSName getLastElement(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.size() > 0 ? arguments.get(arguments.size() - 1) : null;
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static PDColorSpace getColorSpaceFromResources(PDResources resources, COSName colorSpace) {
        try {
            return resources.getColorSpace(colorSpace);
        }
        catch (IOException e) {
            logger.error((Object)("Problems with resources obtaining for " + colorSpace + ". " + e.getMessage()));
            return null;
        }
    }

    private static PDShading getShadingFromResources(PDResources resources, COSName shading) {
        try {
            return resources.getShading(shading);
        }
        catch (IOException e) {
            logger.error((Object)("Problems with resources obtaining for " + shading + ". " + e.getMessage()));
            return null;
        }
    }

    private static PDXObject getXObjectFromResources(PDResources resources, COSName xobject) {
        try {
            return resources.getXObject(xobject);
        }
        catch (IOException e) {
            logger.error((Object)("Problems with resources obtaining for " + xobject + ". " + e.getMessage()));
            return null;
        }
    }

    private static PDExtendedGraphicsState getExtGStateFromResources(PDResources resources, COSName extGState) {
        return resources.getExtGState(extGState);
    }
}

