/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PartnersPanel
extends JPanel {
    private final BufferedImage partnersLogo;
    private Color background;
    private JLabel consortium;
    private JLabel version;

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int imageHeight = (int)((double)this.partnersLogo.getHeight() * 0.5);
        int imageWidth = (int)((double)this.partnersLogo.getWidth() * 0.5);
        int imageStartY = 6 + this.consortium.getHeight();
        int imageStartX = (this.getWidth() - imageWidth) / 2;
        g.setColor(this.background);
        this.consortium.setLocation((this.getWidth() - this.consortium.getWidth()) / 2, 3);
        g.drawImage(this.partnersLogo, imageStartX, imageStartY, imageStartX + imageWidth, imageStartY + imageHeight, 0, 0, this.partnersLogo.getWidth(), this.partnersLogo.getHeight(), this);
        this.version.setLocation((this.getWidth() - this.version.getWidth()) / 2, this.getHeight() - this.version.getHeight() - 3);
    }

    public PartnersPanel(String logoName, Color backgroundColor) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(logoName);
        this.partnersLogo = ImageIO.read(is);
        this.background = backgroundColor;
        this.setLayout(null);
        this.consortium = new JLabel("\u00a9 2015 veraPDF Consortium");
        this.consortium.setHorizontalTextPosition(0);
        this.consortium.setFont(new Font(this.consortium.getFont().getName(), this.consortium.getFont().getStyle(), (int)((double)this.consortium.getFont().getSize() * 1.3)));
        Rectangle2D rec = new TextLayout("\u00a9 2015 veraPDF Consortium", this.consortium.getFont(), new FontRenderContext(null, true, true)).getBounds();
        this.consortium.setSize((int)rec.getWidth() + 6, (int)(rec.getHeight() + 3.0));
        this.add(this.consortium);
        Properties properties = new Properties();
        properties.load(this.getClass().getClassLoader().getResourceAsStream("config.properties"));
        String versionText = "Version: " + properties.getProperty("application.version");
        this.version = new JLabel(versionText);
        this.version.setHorizontalTextPosition(0);
        Rectangle2D recVer = new TextLayout(versionText, this.version.getFont(), new FontRenderContext(null, true, true)).getBounds();
        this.version.setSize((int)recVer.getWidth(), (int)(recVer.getHeight() + 3.0));
        this.add(this.version);
        this.setBackground(backgroundColor);
        int height = (int)((double)this.partnersLogo.getHeight() * 0.5 + (double)(this.consortium.getHeight() * 2) + (double)(this.version.getHeight() * 2));
        this.setPreferredSize(new Dimension(450, height + 6));
    }
}

