/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.profile.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.verapdf.exceptions.validationprofileparser.MissedHashTagException;
import org.verapdf.exceptions.validationprofileparser.NullProfileException;
import org.verapdf.exceptions.validationprofileparser.WrongProfileEncodingException;

public final class ValidationProfileSignatureChecker {
    private static final byte[] KEY_ARRAY = new byte[]{-48, -78, -48, -75, -47, -128, -48, -80, -48, -97, -48, -108, -48, -92};
    private static final String UTF8 = "utf-8";
    private File profile;
    private int startOfHash = -1;
    private int endOfHash = -1;
    private String contentWithoutHash;
    private String currentHashAsString;
    private String realHashAsString;
    private byte[] realHashAsBytes;

    private ValidationProfileSignatureChecker(File file) {
        this.profile = file;
    }

    private void parseProfile() throws IOException, XMLStreamException, WrongProfileEncodingException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader streamReader = factory.createXMLStreamReader(new FileInputStream(this.profile));
        if (!UTF8.equals(streamReader.getEncoding().toLowerCase())) {
            streamReader.close();
            throw new WrongProfileEncodingException("The given profile has not utf-8 encoding: " + this.profile.getCanonicalPath());
        }
        while (streamReader.hasNext()) {
            Location location;
            streamReader.next();
            if (streamReader.isStartElement() && streamReader.getLocalName().equals("hash")) {
                location = streamReader.getLocation();
                this.startOfHash = location.getCharacterOffset();
                this.currentHashAsString = streamReader.getElementText().trim();
            }
            if (!streamReader.isEndElement() || !streamReader.getLocalName().equals("hash")) continue;
            location = streamReader.getLocation();
            this.endOfHash = location.getCharacterOffset();
            if (this.endOfHash != this.startOfHash) {
                this.startOfHash -= "<hash>".length();
                continue;
            }
            this.startOfHash -= "<hash/>".length();
        }
    }

    private byte[] getBytesForHash() throws IOException, MissedHashTagException {
        if (this.startOfHash < 0 || this.endOfHash < 0 || this.startOfHash > this.endOfHash) {
            throw new MissedHashTagException("Can not find well formed hash element in the validation profile at path: " + this.profile.getCanonicalPath());
        }
        byte[] bytesOfFile = Files.readAllBytes(this.profile.toPath());
        String fileString = new String(bytesOfFile, "utf8");
        this.contentWithoutHash = fileString.substring(0, this.startOfHash) + fileString.substring(this.endOfHash);
        return ValidationProfileSignatureChecker.concatenateByteArrays(this.contentWithoutHash.getBytes("utf8"), KEY_ARRAY);
    }

    private static byte[] concatenateByteArrays(byte[] array1, byte[] array2) {
        byte[] res = Arrays.copyOf(array1, array1.length + array2.length);
        for (int i = 0; i < array2.length; ++i) {
            res[i + array1.length] = array2[i];
        }
        return res;
    }

    private static String byteArrayToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private byte[] getSHA1(byte[] source) {
        byte[] res = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            res = md.digest(source);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return res;
    }

    public String getHashAsString() {
        return this.realHashAsString;
    }

    public boolean isValidSignature() {
        return this.realHashAsString.equals(this.currentHashAsString);
    }

    public void signFile() throws IOException {
        String resultingContent = this.contentWithoutHash.substring(0, this.startOfHash) + "<hash>" + this.realHashAsString + "</hash>" + this.contentWithoutHash.substring(this.startOfHash);
        try (FileOutputStream out = new FileOutputStream(this.profile);){
            out.write(resultingContent.getBytes("utf8"));
        }
    }

    public static ValidationProfileSignatureChecker newInstance(File profile) throws MissedHashTagException, XMLStreamException, IOException, WrongProfileEncodingException, NullProfileException {
        if (profile == null) {
            throw new NullProfileException("Null pointer to the profile is used for creating signature checker.");
        }
        ValidationProfileSignatureChecker checker = new ValidationProfileSignatureChecker(profile);
        checker.parseProfile();
        byte[] source = checker.getBytesForHash();
        checker.realHashAsBytes = checker.getSHA1(source);
        checker.realHashAsString = ValidationProfileSignatureChecker.byteArrayToHex(checker.realHashAsBytes);
        return checker;
    }
}

