/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.features.FeaturesReporter;
import org.verapdf.features.pb.PBFeaturesObjectCreator;
import org.verapdf.features.tools.FeaturesCollection;

public final class PBFeatureParser {
    private PBFeatureParser() {
    }

    public static FeaturesCollection getFeaturesCollection(PDDocument document) {
        return PBFeatureParser.getFeaturesCollection(document, new FeaturesReporter());
    }

    public static FeaturesCollection getFeaturesCollection(PDDocument document, FeaturesReporter reporter) {
        if (document != null) {
            reporter.report(PBFeaturesObjectCreator.createInfoDictFeaturesObject(document.getDocumentInformation()));
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            if (catalog != null) {
                PDPageTree pageTree;
                reporter.report(PBFeaturesObjectCreator.createMetadataFeaturesObject(catalog.getMetadata()));
                reporter.report(PBFeaturesObjectCreator.createOutlinesFeaturesObject(catalog.getDocumentOutline()));
                if (catalog.getOutputIntents() != null) {
                    for (PDOutputIntent outInt : document.getDocumentCatalog().getOutputIntents()) {
                        reporter.report(PBFeaturesObjectCreator.createOutputIntentFeaturesObject(outInt));
                    }
                }
                if ((pageTree = catalog.getPages()) != null) {
                    for (PDPage page : pageTree) {
                        reporter.report(PBFeaturesObjectCreator.createPageFeaturesObject(page, pageTree.indexOf(page) + 1));
                    }
                }
            }
            reporter.report(PBFeaturesObjectCreator.createLowLvlInfoFeaturesObject(document.getDocument()));
        }
        return reporter.getCollection();
    }
}

