/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.util.DateConverter;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

public final class XMPChecker {
    private static final Logger logger = Logger.getLogger(XMPChecker.class);
    private static final String TITLE = "Title";
    private static final String SUBJECT = "Subject";
    private static final String AUTHOR = "Author";
    private static final String KEYWORDS = "Keywords";
    private static final String PRODUCER = "Producer";
    private static final String CREATOR = "Creator";
    private static final String CREATION_DATE = "CreationDate";
    private static final String MODIFICATION_DATE = "ModDate";
    private static final Integer MAX_REQUIRED_RECORDS = 8;

    private XMPChecker() {
    }

    public static Boolean doesInfoMatchXMP(COSDocument document) {
        COSDictionary info = XMPChecker.getInformationDictionary(document);
        if (info == null) {
            return Boolean.TRUE;
        }
        try {
            COSStream meta = XMPChecker.getMetadataDictionary(document);
            if (meta != null) {
                DomXmpParser xmpParser = new DomXmpParser();
                XMPMetadata metadata = xmpParser.parse(meta.getUnfilteredStream());
                HashMap<String, Object> properties = new HashMap<String, Object>(MAX_REQUIRED_RECORDS);
                XMPChecker.getTitleAuthorSubject(metadata, properties);
                XMPChecker.getProducerKeywords(metadata, properties);
                XMPChecker.getCreatorAndDates(metadata, properties);
                return XMPChecker.checkMatch(info, properties);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Problems with document parsing or structure. " + e.getMessage()));
        }
        catch (XmpParsingException e) {
            logger.error((Object)("Problems with XMP parsing. " + e.getMessage()));
        }
        return Boolean.FALSE;
    }

    private static COSStream getMetadataDictionary(COSDocument document) throws IOException {
        COSDictionary catalog = (COSDictionary)document.getCatalog().getObject();
        COSObject metaObj = (COSObject)catalog.getItem(COSName.METADATA);
        if (metaObj != null && metaObj.getObject() instanceof COSStream) {
            return (COSStream)metaObj.getObject();
        }
        return null;
    }

    private static COSDictionary getInformationDictionary(COSDocument document) {
        COSObject info = (COSObject)document.getTrailer().getItem(COSName.INFO);
        if (info != null) {
            if (info.getObject() instanceof COSDictionary) {
                return (COSDictionary)info.getObject();
            }
            if (info.getObject() instanceof COSObject) {
                return XMPChecker.getInformationDictionary((COSObject)info.getObject());
            }
        }
        return null;
    }

    private static COSDictionary getInformationDictionary(COSObject object) {
        if (object.getObject() instanceof COSDictionary) {
            return (COSDictionary)object.getObject();
        }
        if (object.getObject() instanceof COSObject) {
            return XMPChecker.getInformationDictionary((COSObject)object.getObject());
        }
        return null;
    }

    private static void getTitleAuthorSubject(XMPMetadata metadata, Map<String, Object> properties) {
        DublinCoreSchema dc = metadata.getDublinCoreSchema();
        if (dc != null) {
            List buffer = dc.getCreators();
            XMPChecker.putProperty(properties, TITLE, dc.getTitle());
            XMPChecker.putProperty(properties, SUBJECT, dc.getDescription());
            if (buffer != null) {
                XMPChecker.putProperty(properties, AUTHOR, buffer.toArray(new String[buffer.size()]));
            }
        }
    }

    private static void getProducerKeywords(XMPMetadata metadata, Map<String, Object> properties) {
        AdobePDFSchema pdf = metadata.getAdobePDFSchema();
        if (pdf != null) {
            XMPChecker.putProperty(properties, KEYWORDS, pdf.getKeywords());
            XMPChecker.putProperty(properties, PRODUCER, pdf.getProducer());
        }
    }

    private static void getCreatorAndDates(XMPMetadata metadata, Map<String, Object> properties) {
        XMPBasicSchema basic = metadata.getXMPBasicSchema();
        if (basic != null) {
            XMPChecker.putProperty(properties, CREATOR, basic.getCreatorTool());
            XMPChecker.putProperty(properties, CREATION_DATE, basic.getCreateDate());
            XMPChecker.putProperty(properties, MODIFICATION_DATE, basic.getModifyDate());
        }
    }

    private static void putProperty(Map<String, Object> properties, String key, String ... values) {
        if (values != null) {
            StringBuilder builder = new StringBuilder();
            for (String value : values) {
                if (value == null || value.isEmpty()) continue;
                builder.append(value).append(" ");
            }
            if (builder.length() > 1) {
                properties.put(key, builder.substring(0, builder.length() - 1));
            }
        }
    }

    private static void putProperty(Map<String, Object> properties, String key, Calendar date) {
        if (date != null) {
            properties.put(key, date);
        }
    }

    private static Boolean checkMatch(COSDictionary info, Map<String, Object> properties) {
        if (XMPChecker.checkProperty(info, properties, TITLE).booleanValue() && XMPChecker.checkProperty(info, properties, SUBJECT).booleanValue() && XMPChecker.checkProperty(info, properties, AUTHOR).booleanValue() && XMPChecker.checkProperty(info, properties, KEYWORDS).booleanValue() && XMPChecker.checkProperty(info, properties, PRODUCER).booleanValue() && XMPChecker.checkProperty(info, properties, CREATOR).booleanValue() && XMPChecker.checkProperty(info, properties, CREATION_DATE).booleanValue() && XMPChecker.checkProperty(info, properties, MODIFICATION_DATE).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean checkProperty(COSDictionary info, Map<String, Object> properties, String checksRule) {
        COSBase item = info.getItem(checksRule);
        if (item != null) {
            if (item instanceof COSString) {
                return XMPChecker.checkCOSStringProperty((COSString)item, properties, checksRule);
            }
            if (item instanceof COSObject) {
                return XMPChecker.deepPropertyCheck((COSObject)item, properties, checksRule);
            }
        } else {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean deepPropertyCheck(COSObject item, Map<String, Object> properties, String checksRule) {
        COSBase external = item.getObject();
        if (external == null || external instanceof COSNull) {
            return Boolean.TRUE;
        }
        if (external instanceof COSString) {
            return XMPChecker.checkCOSStringProperty((COSString)external, properties, checksRule);
        }
        if (external instanceof COSObject) {
            return XMPChecker.deepPropertyCheck((COSObject)external, properties, checksRule);
        }
        return Boolean.FALSE;
    }

    private static Boolean checkCOSStringProperty(COSString string, Map<String, Object> properties, String checksRule) {
        Object value = properties.get(checksRule);
        if (value != null) {
            if (value instanceof String) {
                return value.equals(string.getASCII());
            }
            if (value instanceof Calendar) {
                String regex = "(D:)?(\\d\\d){2,7}(([+-](\\d\\d[']))(\\d\\d['])?)?";
                if (string.getASCII().matches("(D:)?(\\d\\d){2,7}(([+-](\\d\\d[']))(\\d\\d['])?)?")) {
                    Calendar valueDate = DateConverter.toCalendar((COSString)string);
                    return valueDate != null && valueDate.compareTo((Calendar)value) == 0;
                }
            }
        }
        return Boolean.FALSE;
    }
}

