/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.impl.pb.external.PBoxICCOutputProfile;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;

public class PBoxPDOutputIntent
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDOutputIntent {
    public static final Logger logger = Logger.getLogger(PBoxPDOutputIntent.class);

    public PBoxPDOutputIntent(PDOutputIntent simplePDObject) {
        super((COSObjectable)simplePDObject);
        this.setType("PDOutputIntent");
    }

    public String getdestOutputProfileRef() {
        COSDictionary dictionary = (COSDictionary)this.simplePDObject.getCOSObject();
        COSBase item = dictionary.getItem(COSName.DEST_OUTPUT_PROFILE);
        if (item instanceof COSObject) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(((COSObject)item).getObjectNumber()).append(' ');
            buffer.append(((COSObject)item).getGenerationNumber());
            return buffer.toString();
        }
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "destProfile": {
                list = this.getDestProfile();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<ICCOutputProfile> getDestProfile() {
        ArrayList<ICCOutputProfile> profile = new ArrayList<ICCOutputProfile>();
        COSBase dict = this.simplePDObject.getCOSObject();
        String subtype = new String();
        if (dict instanceof COSDictionary) {
            subtype = ((COSDictionary)dict).getNameAsString(COSName.S);
        }
        try {
            COSStream dest = ((PDOutputIntent)this.simplePDObject).getDestOutputIntent();
            if (dest != null) {
                InputStream unfilteredStream = dest.getUnfilteredStream();
                int bound = unfilteredStream.available();
                byte[] bytes = new byte[bound];
                unfilteredStream.read(bytes);
                profile.add(new PBoxICCOutputProfile(bytes, subtype));
                unfilteredStream.close();
            }
        }
        catch (IOException e) {
            logger.error((java.lang.Object)("Can not read dest output profile. " + e.getMessage()));
        }
        return profile;
    }
}

