/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.Assert;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.QualifiedName;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLAssert
extends Assert
implements XSLTConstants {
    protected XMLAssert() {
    }

    public static void assertXMLEqual(Diff diff, boolean assertion) {
        XMLAssert.assertXMLEqual(null, diff, assertion);
    }

    public static void assertXMLEqual(String msg, Diff diff, boolean assertion) {
        if (assertion != diff.similar()) {
            XMLAssert.fail((String)XMLAssert.getFailMessage(msg, diff));
        }
    }

    private static String getFailMessage(String msg, Diff diff) {
        StringBuffer sb = new StringBuffer();
        if (msg != null && msg.length() > 0) {
            sb.append(msg).append(", ");
        }
        return sb.append(diff.toString()).toString();
    }

    public static void assertXMLIdentical(Diff diff, boolean assertion) {
        XMLAssert.assertXMLIdentical(null, diff, assertion);
    }

    public static void assertXMLIdentical(String msg, Diff diff, boolean assertion) {
        if (assertion != diff.identical()) {
            XMLAssert.fail((String)XMLAssert.getFailMessage(msg, diff));
        }
    }

    public static void assertXMLEqual(InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(String control, String test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(Document control, Document test) {
        XMLAssert.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(Reader control, Reader test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(null, control, test);
    }

    public static void assertXMLEqual(String err, InputSource control, InputSource test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, String control, String test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, Reader control, Reader test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLNotEqual(InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(String control, String test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(Document control, Document test) {
        XMLAssert.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(Reader control, Reader test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(null, control, test);
    }

    public static void assertXMLNotEqual(String err, InputSource control, InputSource test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(String err, String control, String test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(String err, Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(String err, Reader control, Reader test) throws SAXException, IOException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, false);
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, InputSource document) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(document));
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathsEqual(String controlXpath, InputSource controlDocument, String testXpath, InputSource testDocument) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, XMLUnit.buildControlDocument(controlDocument), testXpath, XMLUnit.buildTestDocument(testDocument));
    }

    public static void assertXpathsEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathsEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssert.assertXpathEquality(controlXpath, controlDocument, testXpath, testDocument, true);
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, InputSource document) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(document));
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathsNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathsNotEqual(String controlXpath, InputSource controlDocument, String testXpath, InputSource testDocument) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, XMLUnit.buildControlDocument(controlDocument), testXpath, XMLUnit.buildTestDocument(testDocument));
    }

    public static void assertXpathsNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssert.assertXpathEquality(controlXpath, controlDocument, testXpath, testDocument, false);
    }

    private static void assertXpathEquality(String controlXpath, Document controlDocument, String testXpath, Document testDocument, boolean equal) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Diff diff = new Diff(XMLAssert.asXpathResultDocument(XMLUnit.newControlParser(), xpath.getMatchingNodes(controlXpath, controlDocument)), XMLAssert.asXpathResultDocument(XMLUnit.newTestParser(), xpath.getMatchingNodes(testXpath, testDocument)));
        XMLAssert.assertXMLEqual(diff, equal);
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, InputSource document) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(document));
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathValuesEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, XMLUnit.buildControlDocument(control), testXpath, XMLUnit.buildTestDocument(test));
    }

    public static void assertXpathValuesEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathValuesEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        XMLAssert.assertEquals((String)xpath.evaluate(controlXpath, controlDocument), (String)xpath.evaluate(testXpath, testDocument));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, InputSource control) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(control));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathValuesNotEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, XMLUnit.buildControlDocument(control), testXpath, XMLUnit.buildTestDocument(test));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String control = xpath.evaluate(controlXpath, controlDocument);
        String test = xpath.evaluate(testXpath, testDocument);
        if (control != null) {
            if (control.equals(test)) {
                XMLAssert.fail((String)("Expected test value NOT to be equal to control but both were " + test));
            }
        } else if (test != null) {
            XMLAssert.fail((String)("control xPath evaluated to empty node set, but test xPath evaluated to " + test));
        }
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, InputSource control) throws SAXException, IOException, XpathException {
        Document document = XMLUnit.buildControlDocument(control);
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, document);
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, String inXMLString) throws SAXException, IOException, XpathException {
        Document document = XMLUnit.buildControlDocument(inXMLString);
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, document);
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, Document inDocument) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        XMLAssert.assertEquals((String)expectedValue, (String)simpleXpathEngine.evaluate(xpathExpression, inDocument));
    }

    public static void assertXpathEvaluatesTo(QualifiedName expectedValue, String xpathExpression, InputSource control) throws SAXException, IOException, XpathException {
        Document document = XMLUnit.buildControlDocument(control);
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, document);
    }

    public static void assertXpathEvaluatesTo(QualifiedName expectedValue, String xpathExpression, String inXMLString) throws SAXException, IOException, XpathException {
        Document document = XMLUnit.buildControlDocument(inXMLString);
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, document);
    }

    public static void assertXpathEvaluatesTo(QualifiedName expectedValue, String xpathExpression, Document inDocument) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        NodeList nl = simpleXpathEngine.getMatchingNodes(xpathExpression, inDocument);
        NodeBasedNamespaceContext ctx = null;
        if (nl.getLength() > 0) {
            ctx = new NodeBasedNamespaceContext(nl.item(0));
        }
        XMLAssert.assertEquals((Object)expectedValue, (Object)QualifiedName.valueOf(simpleXpathEngine.evaluate(xpathExpression, inDocument), ctx));
    }

    public static void assertXpathExists(String xPathExpression, InputSource control) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument(control);
        XMLAssert.assertXpathExists(xPathExpression, inDocument);
    }

    public static void assertXpathExists(String xPathExpression, String inXMLString) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument(inXMLString);
        XMLAssert.assertXpathExists(xPathExpression, inDocument);
    }

    public static void assertXpathExists(String xPathExpression, Document inDocument) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        NodeList nodeList = simpleXpathEngine.getMatchingNodes(xPathExpression, inDocument);
        int matches = nodeList.getLength();
        XMLAssert.assertTrue((String)("Expecting to find matches for Xpath " + xPathExpression), (matches > 0 ? 1 : 0) != 0);
    }

    public static void assertXpathNotExists(String xPathExpression, InputSource control) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument(control);
        XMLAssert.assertXpathNotExists(xPathExpression, inDocument);
    }

    public static void assertXpathNotExists(String xPathExpression, String inXMLString) throws IOException, SAXException, XpathException {
        Document inDocument = XMLUnit.buildControlDocument(inXMLString);
        XMLAssert.assertXpathNotExists(xPathExpression, inDocument);
    }

    public static void assertXpathNotExists(String xPathExpression, Document inDocument) throws XpathException {
        XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
        NodeList nodeList = simpleXpathEngine.getMatchingNodes(xPathExpression, inDocument);
        int matches = nodeList.getLength();
        XMLAssert.assertEquals((String)("Should be zero matches for Xpath " + xPathExpression), (int)0, (int)matches);
    }

    public static void assertXMLValid(InputSource xml) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(new Validator(xml));
    }

    public static void assertXMLValid(String xmlString) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(new Validator(xmlString));
    }

    public static void assertXMLValid(InputSource xml, String systemId) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(new Validator(xml, systemId));
    }

    public static void assertXMLValid(String xmlString, String systemId) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(new Validator(xmlString, systemId));
    }

    public static void assertXMLValid(InputSource xml, String systemId, String doctype) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(new Validator(xml, systemId, doctype));
    }

    public static void assertXMLValid(String xmlString, String systemId, String doctype) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(new Validator(new StringReader(xmlString), systemId, doctype));
    }

    public static void assertXMLValid(Validator validator) {
        XMLAssert.assertEquals((String)validator.toString(), (boolean)true, (boolean)validator.isValid());
    }

    public static void assertNodeTestPasses(InputSource xml, NodeTester tester, short nodeType) throws SAXException, IOException {
        NodeTest test = new NodeTest(xml);
        XMLAssert.assertNodeTestPasses(test, tester, new short[]{nodeType}, true);
    }

    public static void assertNodeTestPasses(String xmlString, NodeTester tester, short nodeType) throws SAXException, IOException {
        NodeTest test = new NodeTest(xmlString);
        XMLAssert.assertNodeTestPasses(test, tester, new short[]{nodeType}, true);
    }

    public static void assertNodeTestPasses(NodeTest test, NodeTester tester, short[] nodeTypes, boolean assertion) {
        block3: {
            try {
                test.performTest(tester, nodeTypes);
                if (!assertion) {
                    XMLAssert.fail((String)"Expected node test to fail, but it passed!");
                }
            }
            catch (NodeTestException e) {
                if (!assertion) break block3;
                XMLAssert.fail((String)("Expected node test to pass, but it failed! " + e.getMessage()));
            }
        }
    }

    private static Document asXpathResultDocument(DocumentBuilder builder, NodeList nodes) {
        Document d = builder.newDocument();
        Element root = d.createElement("xpathResult");
        d.appendChild(root);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node n = d.importNode(nodes.item(i), true);
            if (n instanceof Attr) {
                root.setAttributeNodeNS((Attr)n);
                continue;
            }
            root.appendChild(n);
        }
        return d;
    }

    private static class NodeBasedNamespaceContext
    implements NamespaceContext {
        private final Node node;

        NodeBasedNamespaceContext(Node n) {
            this.node = n;
        }

        public String getNamespaceURI(String prefix) {
            return this.node.lookupNamespaceURI(prefix);
        }

        public Iterator getPrefixes() {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

