/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;

public final class FeatureTreeNode {
    private String name;
    private String value;
    private FeatureTreeNode parent;
    private FeatureTreeNode root;
    private Map<String, String> attributes;
    private List<FeatureTreeNode> children;

    private FeatureTreeNode(String name, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        this.name = name;
        this.parent = parent;
        if (parent == null) {
            this.root = this;
        } else {
            this.root = parent.getRoot();
            parent.addChild(this);
        }
        this.attributes = new HashMap<String, String>();
    }

    private FeatureTreeNode(String name, String value, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        this.name = name;
        this.value = value;
        this.parent = parent;
        if (parent == null) {
            this.root = this;
        } else {
            this.root = parent.getRoot();
            parent.addChild(this);
        }
        this.attributes = new HashMap<String, String>();
    }

    public static FeatureTreeNode newInstance(String name, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        return new FeatureTreeNode(name, parent);
    }

    public static FeatureTreeNode newInstance(String name, String value, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        return new FeatureTreeNode(name, value, parent);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public FeatureTreeNode getParent() {
        return this.parent;
    }

    public FeatureTreeNode getRoot() {
        return this.root;
    }

    public List<FeatureTreeNode> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public void addChild(FeatureTreeNode child) throws FeaturesTreeNodeException {
        if (child != null) {
            if (this.value == null) {
                if (this.children == null) {
                    this.children = new ArrayList<FeatureTreeNode>();
                }
                this.children.add(child);
            } else {
                throw new FeaturesTreeNodeException("You can not add childrens for nodes with defined values. Node name " + this.name + ", value: " + this.value + ".");
            }
        }
    }

    public void setValue(String value) throws FeaturesTreeNodeException {
        if (this.children != null) {
            throw new FeaturesTreeNodeException("You can not add value for nodes with childrens. Node name " + this.name + ".");
        }
        this.value = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }
}

