/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBOutlinesFeaturesObject
implements IFeaturesObject {
    private static final int RGB_COLORS_NUMBER = 3;
    private static final int RGB_RED_COLOR_NUMBER = 0;
    private static final int RGB_GREEN_COLOR_NUMBER = 1;
    private static final int RGB_BLUE_COLOR_NUMBER = 2;
    private PDDocumentOutline outline;

    public PBOutlinesFeaturesObject(PDDocumentOutline outline) {
        this.outline = outline;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.OUTLINES;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.outline != null) {
            FeatureTreeNode root = FeatureTreeNode.newInstance("outlines", null);
            if (this.outline.children() != null) {
                for (PDOutlineItem item : this.outline.children()) {
                    this.createItem(item, root, collection);
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.OUTLINES, root);
            return root;
        }
        return null;
    }

    private void createItem(PDOutlineItem item, FeatureTreeNode root, FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (item != null) {
            FeatureTreeNode itemNode = FeatureTreeNode.newInstance("outline", root);
            if (item.getTitle() != null) {
                FeatureTreeNode.newInstance("title", item.getTitle(), itemNode);
            }
            if (item.getTextColor() != null) {
                FeatureTreeNode color = FeatureTreeNode.newInstance("color", itemNode);
                PDColor clr = item.getTextColor();
                float[] rgb = clr.getComponents();
                if (rgb.length == 3) {
                    FeatureTreeNode.newInstance("red", String.valueOf(rgb[0]), color);
                    FeatureTreeNode.newInstance("green", String.valueOf(rgb[1]), color);
                    FeatureTreeNode.newInstance("blue", String.valueOf(rgb[2]), color);
                } else {
                    color.addAttribute("errorId", "outlineserr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "outlineserr1", "In Outputlines dictionary value for key \"C\" must be an array of three numbers.");
                }
            }
            FeatureTreeNode.newInstance("italic", String.valueOf(item.isItalic()), itemNode);
            FeatureTreeNode.newInstance("bold", String.valueOf(item.isBold()), itemNode);
            for (PDOutlineItem child : item.children()) {
                this.createItem(child, itemNode, collection);
            }
        }
    }
}

