/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.config;

import org.verapdf.config.Input;

public final class VeraPdfTaskConfig {
    private final boolean validate;
    private final Input input;
    private final String profile;
    private final String output;

    private VeraPdfTaskConfig() {
        this(false, null, null, null);
    }

    public VeraPdfTaskConfig(boolean validate, Input input, String profile, String output) {
        this.validate = validate;
        this.input = input;
        this.profile = profile;
        this.output = output;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public Input getInput() {
        return this.input;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getOutput() {
        return this.output;
    }

    public static class Builder {
        private boolean validate;
        private Input input;
        private String profile;
        private String output;

        public Builder() {
        }

        public Builder(VeraPdfTaskConfig config) {
            this.validate = config.validate;
            this.input = config.input;
            this.profile = config.profile;
            this.output = config.output;
        }

        public Builder validate(boolean validate) {
            this.validate = validate;
            return this;
        }

        public Builder input(Input input) {
            this.input = input;
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder output(String output) {
            this.output = output;
            return this;
        }

        public VeraPdfTaskConfig build() {
            return new VeraPdfTaskConfig(this.validate, this.input, this.profile, this.output);
        }
    }
}

