/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModelHelper {
    private static final Map<String, String> mapOfSuperNames = new HashMap<String, String>();
    private static final Map<String, List<String>> mapOfProperties = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> mapOfLinks = new HashMap<String, List<String>>();
    private static List<String> properties;
    private static List<String> links;

    private ModelHelper() {
    }

    public static List<String> getListOfSuperNames(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = mapOfSuperNames.get(objectName);
        while (currentObject != null) {
            res.add(currentObject);
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static List<String> getListOfProperties(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String prop : mapOfProperties.get(currentObject)) {
                res.add(prop);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    public static List<String> getListOfLinks(String objectName) {
        ArrayList<String> res = new ArrayList<String>();
        String currentObject = objectName;
        while (currentObject != null) {
            for (String link : mapOfLinks.get(currentObject)) {
                res.add(link);
            }
            currentObject = mapOfSuperNames.get(currentObject);
        }
        return res;
    }

    static {
        mapOfSuperNames.put("Object", null);
        properties = new ArrayList<String>();
        mapOfProperties.put("Object", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Object", links);
        mapOfSuperNames.put("CosObject", "Object");
        mapOfSuperNames.put("CosDocument", "CosObject");
        mapOfSuperNames.put("CosIndirect", "CosObject");
        mapOfSuperNames.put("CosNull", "CosObject");
        mapOfSuperNames.put("CosBool", "CosObject");
        mapOfSuperNames.put("CosNumber", "CosObject");
        mapOfSuperNames.put("CosReal", "CosNumber");
        mapOfSuperNames.put("CosInteger", "CosNumber");
        mapOfSuperNames.put("CosName", "CosObject");
        mapOfSuperNames.put("CosRenderingIntent", "CosName");
        mapOfSuperNames.put("CosString", "CosObject");
        mapOfSuperNames.put("CosDict", "CosObject");
        mapOfSuperNames.put("CosStream", "CosDict");
        mapOfSuperNames.put("CosFileSpecification", "CosDict");
        mapOfSuperNames.put("CosTrailer", "CosDict");
        mapOfSuperNames.put("CosArray", "CosObject");
        mapOfSuperNames.put("CosBBox", "CosArray");
        mapOfSuperNames.put("CosXRef", "CosObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("CosObject", properties);
        properties = new ArrayList<String>();
        properties.add("nrIndirects");
        properties.add("size");
        properties.add("version");
        properties.add("isOptionalContentPresent");
        properties.add("eofCompliesPDFA");
        properties.add("doesInfoMatchXMP");
        properties.add("firstPageID");
        properties.add("lastID");
        properties.add("isLinearized");
        properties.add("pdfHeaderCompliesPDFA");
        properties.add("binaryHeaderComplyPDFA");
        mapOfProperties.put("CosDocument", properties);
        properties = new ArrayList<String>();
        properties.add("spacingCompliesPDFA");
        mapOfProperties.put("CosIndirect", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosNull", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        mapOfProperties.put("CosBool", properties);
        properties = new ArrayList<String>();
        properties.add("stringValue");
        properties.add("intValue");
        properties.add("realValue");
        mapOfProperties.put("CosNumber", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosReal", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosInteger", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        properties.add("origLength");
        mapOfProperties.put("CosName", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CosRenderingIntent", properties);
        properties = new ArrayList<String>();
        properties.add("value");
        properties.add("isHex");
        properties.add("isHexSymbols");
        properties.add("hexCount");
        mapOfProperties.put("CosString", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosDict", properties);
        properties = new ArrayList<String>();
        properties.add("Length");
        properties.add("filters");
        properties.add("F");
        properties.add("FFilter");
        properties.add("FDecodeParms");
        properties.add("spacingCompliesPDFA");
        properties.add("isLengthCorrect");
        mapOfProperties.put("CosStream", properties);
        properties = new ArrayList<String>();
        properties.add("EF");
        mapOfProperties.put("CosFileSpecification", properties);
        properties = new ArrayList<String>();
        properties.add("isEncrypted");
        mapOfProperties.put("CosTrailer", properties);
        properties = new ArrayList<String>();
        properties.add("size");
        mapOfProperties.put("CosArray", properties);
        properties = new ArrayList<String>();
        properties.add("top");
        properties.add("bottom");
        properties.add("left");
        properties.add("right");
        mapOfProperties.put("CosBBox", properties);
        properties = new ArrayList<String>();
        properties.add("xrefHeaderSpacingsComplyPDFA");
        properties.add("xrefEOLMarkersComplyPDFA");
        mapOfProperties.put("CosXRef", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("CosObject", links);
        links = new ArrayList<String>();
        links.add("EmbeddedFiles");
        links.add("xref");
        links.add("trailer");
        links.add("indirectObjects");
        links.add("document");
        mapOfLinks.put("CosDocument", links);
        links = new ArrayList<String>();
        links.add("directObject");
        mapOfLinks.put("CosIndirect", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNull", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBool", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosNumber", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosReal", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosInteger", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosName", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosRenderingIntent", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosString", links);
        links = new ArrayList<String>();
        links.add("keys");
        links.add("values");
        links.add("metadata");
        mapOfLinks.put("CosDict", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosStream", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosFileSpecification", links);
        links = new ArrayList<String>();
        links.add("Catalog");
        mapOfLinks.put("CosTrailer", links);
        links = new ArrayList<String>();
        links.add("elements");
        mapOfLinks.put("CosArray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosBBox", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CosXRef", links);
        mapOfSuperNames.put("External", "Object");
        mapOfSuperNames.put("ICCProfile", "External");
        mapOfSuperNames.put("ICCInputProfile", "ICCProfile");
        mapOfSuperNames.put("ICCOutputProfile", "ICCProfile");
        mapOfSuperNames.put("FontProgram", "External");
        mapOfSuperNames.put("CMapFile", "External");
        properties = new ArrayList<String>();
        mapOfProperties.put("External", properties);
        properties = new ArrayList<String>();
        properties.add("deviceClass");
        properties.add("colorSpace");
        properties.add("version");
        properties.add("isValid");
        mapOfProperties.put("ICCProfile", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("ICCInputProfile", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("ICCOutputProfile", properties);
        properties = new ArrayList<String>();
        properties.add("areWidthsConsistent");
        properties.add("areReferencedGlyphsPresent");
        mapOfProperties.put("FontProgram", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CMapFile", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("External", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCInputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("ICCOutputProfile", links);
        links = new ArrayList<String>();
        mapOfLinks.put("FontProgram", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CMapFile", links);
        mapOfSuperNames.put("Operator", "Object");
        mapOfSuperNames.put("OpGeneralGS", "Operator");
        mapOfSuperNames.put("Op_w_line_width", "OpGeneralGS");
        mapOfSuperNames.put("Op_J_line_cap", "OpGeneralGS");
        mapOfSuperNames.put("Op_j_line_join", "OpGeneralGS");
        mapOfSuperNames.put("Op_M_miter_limit", "OpGeneralGS");
        mapOfSuperNames.put("Op_d", "OpGeneralGS");
        mapOfSuperNames.put("Op_ri", "OpGeneralGS");
        mapOfSuperNames.put("Op_i", "OpGeneralGS");
        mapOfSuperNames.put("Op_gs", "OpGeneralGS");
        mapOfSuperNames.put("OpSpecialGS", "Operator");
        mapOfSuperNames.put("Op_q_gsave", "OpSpecialGS");
        mapOfSuperNames.put("Op_Q_grestore", "OpSpecialGS");
        mapOfSuperNames.put("Op_cm", "OpSpecialGS");
        mapOfSuperNames.put("OpPathConstruction", "Operator");
        mapOfSuperNames.put("Op_m_moveto", "OpPathConstruction");
        mapOfSuperNames.put("Op_l", "OpPathConstruction");
        mapOfSuperNames.put("Op_c", "OpPathConstruction");
        mapOfSuperNames.put("Op_v", "OpPathConstruction");
        mapOfSuperNames.put("Op_y", "OpPathConstruction");
        mapOfSuperNames.put("Op_h", "OpPathConstruction");
        mapOfSuperNames.put("Op_re", "OpPathConstruction");
        mapOfSuperNames.put("OpPathPaint", "Operator");
        mapOfSuperNames.put("Op_s_close_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_S_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_f_fill", "OpPathPaint");
        mapOfSuperNames.put("Op_F_fill_obsolete", "OpPathPaint");
        mapOfSuperNames.put("Op_FStar", "OpPathPaint");
        mapOfSuperNames.put("Op_B_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_BStar_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_b_closepath_fill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_bstar_closepath_eofill_stroke", "OpPathPaint");
        mapOfSuperNames.put("Op_n", "OpPathPaint");
        mapOfSuperNames.put("OpClip", "Operator");
        mapOfSuperNames.put("Op_W_clip", "OpClip");
        mapOfSuperNames.put("Op_WStar", "OpClip");
        mapOfSuperNames.put("OpTextObject", "Operator");
        mapOfSuperNames.put("OpTextState", "Operator");
        mapOfSuperNames.put("Op_Tz", "OpTextState");
        mapOfSuperNames.put("OpTextPosition", "Operator");
        mapOfSuperNames.put("Op_Td", "OpTextPosition");
        mapOfSuperNames.put("Op_TD_Big", "OpTextPosition");
        mapOfSuperNames.put("OpTextShow", "Operator");
        mapOfSuperNames.put("Op_Tj", "OpTextShow");
        mapOfSuperNames.put("Op_TJ_Big", "OpTextShow");
        mapOfSuperNames.put("Op_Quote", "OpTextShow");
        mapOfSuperNames.put("Op_DoubleQuote", "OpTextShow");
        mapOfSuperNames.put("OpType3Font", "Operator");
        mapOfSuperNames.put("OpColor", "Operator");
        mapOfSuperNames.put("OpShading", "Operator");
        mapOfSuperNames.put("Op_sh", "OpShading");
        mapOfSuperNames.put("OpInlineImage", "Operator");
        mapOfSuperNames.put("OpXObject", "Operator");
        mapOfSuperNames.put("Op_Do", "OpXObject");
        mapOfSuperNames.put("OpMarkedContent", "Operator");
        mapOfSuperNames.put("Op_MP", "OpMarkedContent");
        mapOfSuperNames.put("Op_DP", "OpMarkedContent");
        mapOfSuperNames.put("Op_BMC", "OpMarkedContent");
        mapOfSuperNames.put("Op_BDC", "OpMarkedContent");
        mapOfSuperNames.put("Op_EMC", "OpMarkedContent");
        mapOfSuperNames.put("OpCompatibility", "Operator");
        mapOfSuperNames.put("Op_BX", "OpCompatibility");
        mapOfSuperNames.put("Op_EX", "OpCompatibility");
        mapOfSuperNames.put("Op_Undefined", "OpCompatibility");
        properties = new ArrayList<String>();
        mapOfProperties.put("Operator", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpGeneralGS", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_w_line_width", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_J_line_cap", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_j_line_join", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_M_miter_limit", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_d", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_ri", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_i", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_gs", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpSpecialGS", properties);
        properties = new ArrayList<String>();
        properties.add("nestingLevel");
        mapOfProperties.put("Op_q_gsave", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Q_grestore", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_cm", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathConstruction", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_m_moveto", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_l", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_c", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_v", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_y", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_h", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_re", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpPathPaint", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_s_close_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_S_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_f_fill", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_F_fill_obsolete", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_FStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_B_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BStar_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_b_closepath_fill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_bstar_closepath_eofill_stroke", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_n", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpClip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_W_clip", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_WStar", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextState", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tz", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextPosition", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Td", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TD_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpTextShow", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Tj", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_TJ_Big", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Quote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DoubleQuote", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpType3Font", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpColor", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpShading", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_sh", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpInlineImage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpXObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Do", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpMarkedContent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_MP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_DP", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BDC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EMC", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("OpCompatibility", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_BX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_EX", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("Op_Undefined", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("Operator", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpGeneralGS", links);
        links = new ArrayList<String>();
        links.add("lineWidth");
        mapOfLinks.put("Op_w_line_width", links);
        links = new ArrayList<String>();
        links.add("lineCap");
        mapOfLinks.put("Op_J_line_cap", links);
        links = new ArrayList<String>();
        links.add("lineJoin");
        mapOfLinks.put("Op_j_line_join", links);
        links = new ArrayList<String>();
        links.add("miterLimit");
        mapOfLinks.put("Op_M_miter_limit", links);
        links = new ArrayList<String>();
        links.add("dashArray");
        links.add("dashPhase");
        mapOfLinks.put("Op_d", links);
        links = new ArrayList<String>();
        links.add("renderingIntent");
        mapOfLinks.put("Op_ri", links);
        links = new ArrayList<String>();
        links.add("flatness");
        mapOfLinks.put("Op_i", links);
        links = new ArrayList<String>();
        links.add("extGState");
        mapOfLinks.put("Op_gs", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpSpecialGS", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_q_gsave", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Q_grestore", links);
        links = new ArrayList<String>();
        links.add("matrix");
        mapOfLinks.put("Op_cm", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathConstruction", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_m_moveto", links);
        links = new ArrayList<String>();
        links.add("point");
        mapOfLinks.put("Op_l", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_c", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_v", links);
        links = new ArrayList<String>();
        links.add("controlPoints");
        mapOfLinks.put("Op_y", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_h", links);
        links = new ArrayList<String>();
        links.add("rectBox");
        mapOfLinks.put("Op_re", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpPathPaint", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_s_close_stroke", links);
        links = new ArrayList<String>();
        links.add("strokeCS");
        mapOfLinks.put("Op_S_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_f_fill", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_F_fill_obsolete", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        mapOfLinks.put("Op_FStar", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_B_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_BStar_eofill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_b_closepath_fill_stroke", links);
        links = new ArrayList<String>();
        links.add("fillCS");
        links.add("strokeCS");
        mapOfLinks.put("Op_bstar_closepath_eofill_stroke", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_n", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpClip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_W_clip", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_WStar", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextObject", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextState", links);
        links = new ArrayList<String>();
        links.add("scale");
        mapOfLinks.put("Op_Tz", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpTextPosition", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_Td", links);
        links = new ArrayList<String>();
        links.add("horizontalOffset");
        links.add("verticalOffset");
        mapOfLinks.put("Op_TD_Big", links);
        links = new ArrayList<String>();
        links.add("font");
        mapOfLinks.put("OpTextShow", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Tj", links);
        links = new ArrayList<String>();
        links.add("specialStrings");
        mapOfLinks.put("Op_TJ_Big", links);
        links = new ArrayList<String>();
        links.add("showString");
        mapOfLinks.put("Op_Quote", links);
        links = new ArrayList<String>();
        links.add("showString");
        links.add("wordSpacing");
        links.add("characterSpacing");
        mapOfLinks.put("Op_DoubleQuote", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpType3Font", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpColor", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpShading", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("Op_sh", links);
        links = new ArrayList<String>();
        links.add("inlineImageDictionary");
        mapOfLinks.put("OpInlineImage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpXObject", links);
        links = new ArrayList<String>();
        links.add("xObject");
        mapOfLinks.put("Op_Do", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpMarkedContent", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_MP", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        mapOfLinks.put("Op_DP", links);
        links = new ArrayList<String>();
        links.add("tag");
        mapOfLinks.put("Op_BMC", links);
        links = new ArrayList<String>();
        links.add("tag");
        links.add("properties");
        mapOfLinks.put("Op_BDC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EMC", links);
        links = new ArrayList<String>();
        mapOfLinks.put("OpCompatibility", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_BX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_EX", links);
        links = new ArrayList<String>();
        mapOfLinks.put("Op_Undefined", links);
        mapOfSuperNames.put("PDObject", "Object");
        mapOfSuperNames.put("PDDocument", "PDObject");
        mapOfSuperNames.put("PDPage", "PDObject");
        mapOfSuperNames.put("PDContentStream", "PDObject");
        mapOfSuperNames.put("PDResource", "PDObject");
        mapOfSuperNames.put("PDColorSpace", "PDResource");
        mapOfSuperNames.put("PDDeviceGray", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceRGB", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceCMYK", "PDColorSpace");
        mapOfSuperNames.put("PDICCBased", "PDColorSpace");
        mapOfSuperNames.put("PDLab", "PDColorSpace");
        mapOfSuperNames.put("PDCalGray", "PDColorSpace");
        mapOfSuperNames.put("PDCalRGB", "PDColorSpace");
        mapOfSuperNames.put("PDSeparation", "PDColorSpace");
        mapOfSuperNames.put("PDDeviceN", "PDColorSpace");
        mapOfSuperNames.put("PDIndexed", "PDColorSpace");
        mapOfSuperNames.put("PDPattern", "PDColorSpace");
        mapOfSuperNames.put("PDTilingPattern", "PDPattern");
        mapOfSuperNames.put("PDShadingPattern", "PDPattern");
        mapOfSuperNames.put("PDFont", "PDResource");
        mapOfSuperNames.put("PDSimpleFont", "PDFont");
        mapOfSuperNames.put("PDType3Font", "PDSimpleFont");
        mapOfSuperNames.put("PDCIDFont", "PDFont");
        mapOfSuperNames.put("PDType0Font", "PDFont");
        mapOfSuperNames.put("PDCMap", "PDObject");
        mapOfSuperNames.put("PDXObject", "PDResource");
        mapOfSuperNames.put("PDXImage", "PDXObject");
        mapOfSuperNames.put("PDXForm", "PDXObject");
        mapOfSuperNames.put("PDGroup", "PDObject");
        mapOfSuperNames.put("PDExtGState", "PDResource");
        mapOfSuperNames.put("PDShading", "PDResource");
        mapOfSuperNames.put("PDAnnot", "PDObject");
        mapOfSuperNames.put("PDAcroForm", "PDObject");
        mapOfSuperNames.put("PDFormField", "PDObject");
        mapOfSuperNames.put("PDAction", "PDObject");
        mapOfSuperNames.put("PDNamedAction", "PDAction");
        mapOfSuperNames.put("PDMetadata", "PDObject");
        mapOfSuperNames.put("PDOutputIntent", "PDObject");
        mapOfSuperNames.put("PDOutline", "PDObject");
        properties = new ArrayList<String>();
        mapOfProperties.put("PDObject", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDocument", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPage", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDContentStream", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDResource", properties);
        properties = new ArrayList<String>();
        properties.add("nrComponents");
        mapOfProperties.put("PDColorSpace", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceRGB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceCMYK", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDICCBased", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDLab", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalGray", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDCalRGB", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDSeparation", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDDeviceN", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDIndexed", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDTilingPattern", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShadingPattern", properties);
        properties = new ArrayList<String>();
        properties.add("Type");
        properties.add("Subtype");
        properties.add("BaseFont");
        mapOfProperties.put("PDFont", properties);
        properties = new ArrayList<String>();
        properties.add("isStandard");
        properties.add("FirstChar");
        properties.add("LastChar");
        properties.add("Widths_size");
        mapOfProperties.put("PDSimpleFont", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDType3Font", properties);
        properties = new ArrayList<String>();
        properties.add("CIDtoGIDMap");
        mapOfProperties.put("PDCIDFont", properties);
        properties = new ArrayList<String>();
        properties.add("areRegistryOrderingCompatible");
        mapOfProperties.put("PDType0Font", properties);
        properties = new ArrayList<String>();
        properties.add("CMapName");
        mapOfProperties.put("PDCMap", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        mapOfProperties.put("PDXObject", properties);
        properties = new ArrayList<String>();
        properties.add("Interpolate");
        mapOfProperties.put("PDXImage", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype2");
        mapOfProperties.put("PDXForm", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDGroup", properties);
        properties = new ArrayList<String>();
        properties.add("TR");
        properties.add("TR2");
        properties.add("SMask");
        properties.add("BM");
        properties.add("ca");
        properties.add("CA");
        mapOfProperties.put("PDExtGState", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDShading", properties);
        properties = new ArrayList<String>();
        properties.add("Subtype");
        properties.add("CA");
        properties.add("F");
        properties.add("AP");
        mapOfProperties.put("PDAnnot", properties);
        properties = new ArrayList<String>();
        properties.add("NeedAppearances");
        mapOfProperties.put("PDAcroForm", properties);
        properties = new ArrayList<String>();
        properties.add("FT");
        mapOfProperties.put("PDFormField", properties);
        properties = new ArrayList<String>();
        properties.add("S");
        mapOfProperties.put("PDAction", properties);
        properties = new ArrayList<String>();
        properties.add("N");
        mapOfProperties.put("PDNamedAction", properties);
        properties = new ArrayList<String>();
        properties.add("Filter");
        mapOfProperties.put("PDMetadata", properties);
        properties = new ArrayList<String>();
        properties.add("destOutputProfileRef");
        mapOfProperties.put("PDOutputIntent", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("PDOutline", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("PDObject", links);
        links = new ArrayList<String>();
        links.add("pages");
        links.add("metadata");
        links.add("outputIntents");
        links.add("AcroForm");
        links.add("AA");
        links.add("OpenAction");
        links.add("Outlines");
        mapOfLinks.put("PDDocument", links);
        links = new ArrayList<String>();
        links.add("annots");
        links.add("action");
        links.add("contentStream");
        links.add("Group");
        mapOfLinks.put("PDPage", links);
        links = new ArrayList<String>();
        links.add("operators");
        mapOfLinks.put("PDContentStream", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDResource", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDColorSpace", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceRGB", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDDeviceCMYK", links);
        links = new ArrayList<String>();
        links.add("iccProfile");
        mapOfLinks.put("PDICCBased", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDLab", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalGray", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCalRGB", links);
        links = new ArrayList<String>();
        links.add("alternate");
        mapOfLinks.put("PDSeparation", links);
        links = new ArrayList<String>();
        links.add("alternate");
        mapOfLinks.put("PDDeviceN", links);
        links = new ArrayList<String>();
        links.add("base");
        mapOfLinks.put("PDIndexed", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDPattern", links);
        links = new ArrayList<String>();
        links.add("contentStream");
        mapOfLinks.put("PDTilingPattern", links);
        links = new ArrayList<String>();
        links.add("shading");
        mapOfLinks.put("PDShadingPattern", links);
        links = new ArrayList<String>();
        links.add("fontFile");
        mapOfLinks.put("PDFont", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDSimpleFont", links);
        links = new ArrayList<String>();
        links.add("charStrings");
        mapOfLinks.put("PDType3Font", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDCIDFont", links);
        links = new ArrayList<String>();
        links.add("DescendantFonts");
        links.add("Encoding");
        mapOfLinks.put("PDType0Font", links);
        links = new ArrayList<String>();
        links.add("embeddedFile");
        mapOfLinks.put("PDCMap", links);
        links = new ArrayList<String>();
        links.add("OPI");
        links.add("SMask");
        mapOfLinks.put("PDXObject", links);
        links = new ArrayList<String>();
        links.add("imageCS");
        links.add("Alternates");
        links.add("Intent");
        mapOfLinks.put("PDXImage", links);
        links = new ArrayList<String>();
        links.add("PS");
        links.add("Ref");
        links.add("contentStream");
        links.add("Group");
        mapOfLinks.put("PDXForm", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDGroup", links);
        links = new ArrayList<String>();
        links.add("RI");
        mapOfLinks.put("PDExtGState", links);
        links = new ArrayList<String>();
        links.add("colorSpace");
        mapOfLinks.put("PDShading", links);
        links = new ArrayList<String>();
        links.add("appearance");
        links.add("C");
        links.add("IC");
        links.add("A");
        links.add("AA");
        mapOfLinks.put("PDAnnot", links);
        links = new ArrayList<String>();
        links.add("formFields");
        mapOfLinks.put("PDAcroForm", links);
        links = new ArrayList<String>();
        links.add("AA");
        mapOfLinks.put("PDFormField", links);
        links = new ArrayList<String>();
        links.add("Next");
        mapOfLinks.put("PDAction", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDNamedAction", links);
        links = new ArrayList<String>();
        links.add("XMPPackage");
        links.add("stream");
        mapOfLinks.put("PDMetadata", links);
        links = new ArrayList<String>();
        links.add("destProfile");
        mapOfLinks.put("PDOutputIntent", links);
        links = new ArrayList<String>();
        links.add("A");
        mapOfLinks.put("PDOutline", links);
        mapOfSuperNames.put("XMPObject", "Object");
        mapOfSuperNames.put("XMPPackage", "XMPObject");
        mapOfSuperNames.put("XMPMainPackage", "XMPPackage");
        mapOfSuperNames.put("XMPSchema", "XMPObject");
        mapOfSuperNames.put("XMPPredefinedSchema", "XMPSchema");
        mapOfSuperNames.put("XMPCustomSchema", "XMPSchema");
        mapOfSuperNames.put("PDFAIdSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("PDFAExtensionSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("XMPBasicSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("XMPRightsSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("XMPMMSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("XMPTPgSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("PDFSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("PhotoshopSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("CRSSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("AUXSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("XMPDMSchema", "XMPPredefinedSchema");
        mapOfSuperNames.put("XAPSSchema", "XMPPredefinedSchema");
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPObject", properties);
        properties = new ArrayList<String>();
        properties.add("isMetadataValid");
        properties.add("bytes");
        properties.add("encoding");
        mapOfProperties.put("XMPPackage", properties);
        properties = new ArrayList<String>();
        properties.add("ispdfaidNSPresent");
        mapOfProperties.put("XMPMainPackage", properties);
        properties = new ArrayList<String>();
        properties.add("uri");
        properties.add("prefix");
        mapOfProperties.put("XMPSchema", properties);
        properties = new ArrayList<String>();
        properties.add("unknownProperties");
        properties.add("wrongValueTypeProperties");
        mapOfProperties.put("XMPPredefinedSchema", properties);
        properties = new ArrayList<String>();
        properties.add("isDefinitionCorrect");
        properties.add("isDefinedInThisPackage");
        mapOfProperties.put("XMPCustomSchema", properties);
        properties = new ArrayList<String>();
        properties.add("part");
        properties.add("conformance");
        properties.add("amd");
        properties.add("corr");
        mapOfProperties.put("PDFAIdSchema", properties);
        properties = new ArrayList<String>();
        properties.add("isPDFAFieldPrefixCorrect");
        properties.add("isPDFAPropertyPrefixCorrect");
        properties.add("isPDFASchemaPrefixCorrect");
        properties.add("isPDFATypePrefixCorrect");
        mapOfProperties.put("PDFAExtensionSchema", properties);
        properties = new ArrayList<String>();
        properties.add("author");
        properties.add("description");
        properties.add("label");
        properties.add("rating");
        properties.add("title");
        mapOfProperties.put("XMPBasicSchema", properties);
        properties = new ArrayList<String>();
        properties.add("copyright");
        mapOfProperties.put("XMPRightsSchema", properties);
        properties = new ArrayList<String>();
        properties.add("manifest");
        mapOfProperties.put("XMPMMSchema", properties);
        properties = new ArrayList<String>();
        properties.add("colorants");
        properties.add("fonts");
        properties.add("plateNames");
        mapOfProperties.put("XMPTPgSchema", properties);
        properties = new ArrayList<String>();
        properties.add("author");
        properties.add("baseURL");
        properties.add("creationDate");
        properties.add("creator");
        properties.add("modDate");
        properties.add("subject");
        properties.add("title");
        properties.add("trapped");
        mapOfProperties.put("PDFSchema", properties);
        properties = new ArrayList<String>();
        properties.add("author");
        properties.add("copyright");
        properties.add("history");
        properties.add("title");
        mapOfProperties.put("PhotoshopSchema", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("CRSSchema", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("AUXSchema", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("XMPDMSchema", properties);
        properties = new ArrayList<String>();
        mapOfProperties.put("XAPSSchema", properties);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPObject", links);
        links = new ArrayList<String>();
        links.add("Schemas");
        mapOfLinks.put("XMPPackage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPMainPackage", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPPredefinedSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPCustomSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFAIdSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFAExtensionSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPBasicSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPRightsSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPMMSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPTPgSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PDFSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("PhotoshopSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("CRSSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("AUXSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XMPDMSchema", links);
        links = new ArrayList<String>();
        mapOfLinks.put("XAPSSchema", links);
    }
}

