/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller.resource;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.unix.ShellScript;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RootScripts {
    private final List<String> scripts;
    private static final Logger logger = Logger.getLogger(RootScripts.class.getName());

    public RootScripts(Resources resources, Platform platform) {
        this.scripts = platform.isA(Platform.Name.UNIX) ? this.getRootScripts(resources) : null;
    }

    public void run() {
        if (this.scripts != null) {
            for (String script : this.scripts) {
                this.run(script);
            }
        }
    }

    private List<String> getRootScripts(Resources resources) {
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        while (true) {
            try {
                String name = "rootscript" + Integer.toString(index);
                ObjectInputStream in = null;
                try {
                    InputStream inputStream = resources.getInputStream(name);
                    in = new ObjectInputStream(inputStream);
                    result.add(in.readUTF());
                }
                catch (IOException exception) {
                    try {
                        throw new IzPackException("Failed to read resource: " + name, exception);
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(in);
                        throw throwable;
                    }
                }
                FileUtils.close(in);
            }
            catch (ResourceNotFoundException ignore) {
                break;
            }
            ++index;
        }
        return result;
    }

    protected void run(String script) {
        try {
            boolean enabled = logger.isLoggable(Level.FINE);
            if (enabled) {
                logger.fine("Executing script: " + script);
            }
            File file = File.createTempFile("izpackrootscript", ".sh");
            String result = ShellScript.execAndDelete(new StringBuffer(script), file.getPath());
            if (enabled) {
                logger.fine("Result: " + result);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to execute script: " + exception.getMessage(), exception);
        }
    }
}

