/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.file.types.selectors.BaseSelectorContainer;
import com.izforge.izpack.util.file.types.selectors.FileSelector;
import java.io.File;
import java.util.Enumeration;

public class SelectSelector
extends BaseSelectorContainer {
    private String ifProperty;
    private String unlessProperty;

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.hasSelectors()) {
            buf.append("{select");
            if (this.ifProperty != null) {
                buf.append(" if: ");
                buf.append(this.ifProperty);
            }
            if (this.unlessProperty != null) {
                buf.append(" unless: ");
                buf.append(this.unlessProperty);
            }
            buf.append(" ");
            buf.append(super.toString());
            buf.append("}");
        }
        return buf.toString();
    }

    @Override
    public void verifySettings() {
        int cnt = this.selectorCount();
        if (cnt < 0 || cnt > 1) {
            this.setError("Only one selector is allowed within the <selector> tag");
        }
    }

    public boolean passesConditions(InstallData idata) {
        if (this.ifProperty != null && idata.getVariable(this.ifProperty) == null) {
            return false;
        }
        return this.unlessProperty == null || idata.getVariable(this.unlessProperty) == null;
    }

    public void setIf(String ifProperty) {
        this.ifProperty = ifProperty;
    }

    public void setUnless(String unlessProperty) {
        this.unlessProperty = unlessProperty;
    }

    @Override
    public boolean isSelected(InstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        if (!this.passesConditions(idata)) {
            return false;
        }
        Enumeration<FileSelector> e = this.selectorElements();
        if (!e.hasMoreElements()) {
            return true;
        }
        FileSelector f = e.nextElement();
        return f.isSelected(idata, basedir, filename, file);
    }
}

