/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class ScriptParser {
    private static final Logger logger = Logger.getLogger(ScriptParser.class.getName());
    private final VariableSubstitutor replacer;
    private final PlatformModelMatcher matcher;

    public ScriptParser(VariableSubstitutor replacer, PlatformModelMatcher matcher) {
        this.replacer = replacer;
        this.matcher = matcher;
    }

    public void parse(ParsableFile parsable) throws Exception {
        File parsedFile;
        if (!this.matcher.matchesCurrentPlatform(parsable.getOsConstraints())) {
            return;
        }
        File file = new File(parsable.getPath());
        logger.fine("Parsing and replacing variables in file " + file + "...");
        try {
            parsedFile = File.createTempFile("izpp", null, file.getParentFile());
        }
        catch (IOException exception) {
            throw new IOException("Failed to create temporary file for " + parsable.getPath() + " in directory " + file.getParentFile(), exception);
        }
        FileInputStream inFile = new FileInputStream(file);
        BufferedInputStream in = new BufferedInputStream(inFile, 5120);
        FileOutputStream outFile = new FileOutputStream(parsedFile);
        BufferedOutputStream out = new BufferedOutputStream(outFile, 5120);
        this.replacer.substitute(in, out, parsable.getType(), parsable.getEncoding());
        in.close();
        out.close();
        if (!file.delete()) {
            throw new IOException("Failed to delete file: " + file);
        }
        if (!parsedFile.renameTo(file)) {
            throw new IOException("Could not rename file " + parsedFile + " to " + file);
        }
    }
}

