/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.panels.target.TargetPanelAutomation;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.Console;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;

public class TargetConsolePanel
extends AbstractConsolePanel
implements ConsolePanel {
    private final InstallData installData;

    public TargetConsolePanel(PanelView<ConsolePanel> panel, InstallData installData) {
        super(panel);
        this.installData = installData;
    }

    @Override
    public boolean generateProperties(InstallData installData, PrintWriter printWriter) {
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        boolean result = false;
        String path = properties.getProperty("INSTALL_PATH");
        if (path == null || "".equals(path.trim())) {
            System.err.println("Missing mandatory target path!");
        } else if (TargetPanelHelper.isIncompatibleInstallation(path)) {
            System.err.println(this.getIncompatibleInstallationMsg(installData));
        } else {
            path = installData.getVariables().replace(path);
            installData.setInstallPath(path);
            result = true;
        }
        return result;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        String path;
        String defaultPath = TargetPanelHelper.getPath(installData);
        PathInputBase.setInstallData(installData);
        if (defaultPath == null) {
            defaultPath = "";
        }
        if ((path = console.promptLocation(installData.getMessages().get("TargetPanel.info", new Object[0]) + " [" + defaultPath + "] ", defaultPath, null)) != null) {
            path = installData.getVariables().replace(path);
            String normalizedPath = PathInputBase.normalizePath(path);
            File pathFile = new File(normalizedPath);
            if (TargetPanelHelper.isIncompatibleInstallation(normalizedPath)) {
                console.println(this.getIncompatibleInstallationMsg(installData));
                return this.run(installData, console);
            }
            if (!PathInputBase.isWritable(normalizedPath)) {
                console.println(installData.getMessages().get("UserPathPanel.notwritable", new Object[0]));
                return this.run(installData, console);
            }
            if (!normalizedPath.isEmpty()) {
                if (pathFile.isFile()) {
                    console.println(installData.getMessages().get("PathInputPanel.isfile", new Object[0]));
                    return this.run(installData, console);
                }
                if (pathFile.isDirectory() && pathFile.list().length > 0) {
                    console.println(installData.getMessages().get("TargetPanel.warn", new Object[0]));
                } else if (!installData.getPlatform().isValidDirectoryPath(pathFile)) {
                    console.println(installData.getMessages().get("TargetPanel.syntax.error", new Object[0]));
                    return this.run(installData, console);
                }
                installData.setInstallPath(normalizedPath);
                return this.promptEndPanel(installData, console);
            }
            return this.run(installData, console);
        }
        return false;
    }

    private String getIncompatibleInstallationMsg(InstallData installData) {
        return installData.getMessages().get("TargetPanel.incompatibleInstallation", new Object[0]);
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        new TargetPanelAutomation().createInstallationRecord(this.installData, panelRoot);
    }
}

