/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller.resource;

import com.izforge.izpack.api.data.ExecutableFile;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class Executables {
    private final List<ExecutableFile> executables;
    private final PlatformModelMatcher matcher;
    private final Prompt prompt;
    private static final Logger logger = Logger.getLogger(Executables.class.getName());

    public Executables(Resources resources, PlatformModelMatcher matcher, Prompt prompt) {
        this.prompt = prompt;
        this.matcher = matcher;
        this.executables = this.read(resources);
    }

    public boolean run() {
        for (ExecutableFile file : this.executables) {
            if (file.executionStage != 2 || !this.matcher.matchesCurrentPlatform(file.osList) || this.run(file)) continue;
            return false;
        }
        return true;
    }

    protected boolean run(ExecutableFile file) {
        FileExecutor executor = new FileExecutor(Arrays.asList(file));
        int status = executor.executeFiles(2, this.matcher, new PromptUIHandler(this.prompt));
        if (status != 0) {
            logger.severe("Executable=" + file.path + " exited with status=" + status);
            return false;
        }
        return true;
    }

    private List<ExecutableFile> read(Resources resources) {
        ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
        try {
            ObjectInputStream in = new ObjectInputStream(resources.getInputStream("executables"));
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                ExecutableFile file = (ExecutableFile)in.readObject();
                executables.add(file);
            }
        }
        catch (Exception exception) {
            throw new IzPackException("Failed to read executable resources", exception);
        }
        return executables;
    }
}

