/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.event.ActionBase;
import com.izforge.izpack.event.AntActionInputHandler;
import com.izforge.izpack.event.AntActionLogBuildListener;
import com.izforge.izpack.event.AntLogLevel;
import com.izforge.izpack.event.AntSystemLogBuildListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.util.JavaEnvUtils;

public class AntAction
extends ActionBase {
    private static final long serialVersionUID = 3258131345250005557L;
    public static final String CONDITIONID_ATTR = "condition";
    public static final String ANTCALL = "antcall";
    private boolean quiet = false;
    private boolean verbose = false;
    private AntLogLevel logLevel = AntLogLevel.INFO;
    private Prompt.Type severity = Prompt.Type.ERROR;
    private Properties properties = new Properties();
    private List<String> targets = new ArrayList<String>();
    private List<String> uninstallTargets = new ArrayList<String>();
    private File logFile = null;
    private boolean logFileAppend = false;
    private File buildDir = null;
    private File buildFile = null;
    private String conditionId = null;
    private List<String> propertyFiles = new ArrayList<String>();

    public void performInstallAction() throws IzPackException {
        this.performAction(false);
    }

    public void performUninstallAction() throws IzPackException {
        this.performAction(true);
    }

    public void performAction(boolean uninstall) throws IzPackException {
        if (this.verbose) {
            System.out.print("Calling ANT with buildfile: " + this.buildFile);
            System.out.print(this.buildDir != null ? " in directory " + this.buildDir : " in default base directory");
            System.out.println();
        }
        SecurityManager oldsm = null;
        if (!JavaEnvUtils.isJavaVersion((String)"1.0") && !JavaEnvUtils.isJavaVersion((String)"1.1")) {
            oldsm = System.getSecurityManager();
        }
        PrintStream err = System.err;
        PrintStream out = System.out;
        Project antProj = new Project();
        try {
            List<String> choosenTargets;
            antProj.setInputHandler((InputHandler)new AntActionInputHandler());
            antProj.setName("antcallproject");
            if (this.verbose) {
                this.logLevel = AntLogLevel.VERBOSE;
            } else if (this.quiet) {
                this.logLevel = AntLogLevel.WARNING;
            }
            int antLogLevel = this.logLevel.getLevel();
            antProj.addBuildListener((BuildListener)new AntSystemLogBuildListener(antLogLevel));
            if (this.logFile != null) {
                antProj.addBuildListener((BuildListener)new AntActionLogBuildListener(this.logFile, this.logFileAppend, antLogLevel));
            }
            antProj.setSystemProperties();
            this.addProperties(antProj, this.getProperties());
            this.addPropertiesFromPropertyFiles(antProj);
            antProj.fireBuildStarted();
            antProj.init();
            ArrayList<Ant> antcalls = new ArrayList<Ant>();
            List<String> list = choosenTargets = uninstall ? this.uninstallTargets : this.targets;
            if (choosenTargets.size() > 0) {
                for (String choosenTarget : choosenTargets) {
                    Ant antcall = (Ant)antProj.createTask("ant");
                    if (this.buildDir != null) {
                        antcall.setDir(this.buildDir);
                    }
                    antcall.setAntfile(this.buildFile.getAbsolutePath());
                    antcall.setTarget(choosenTarget);
                    antcalls.add(antcall);
                }
            }
            Target target = new Target();
            target.setName("calltarget");
            for (Ant antcall : antcalls) {
                target.addTask((Task)antcall);
            }
            antProj.addTarget(target);
            System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(antProj, false)));
            System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(antProj, true)));
            antProj.executeTarget("calltarget");
            antProj.fireBuildFinished(null);
        }
        catch (BuildException exception) {
            antProj.fireBuildFinished((Throwable)exception);
            throw new IzPackException("Ant build failed", exception, this.getSeverity());
        }
        finally {
            if (oldsm != null) {
                System.setSecurityManager(oldsm);
            }
            System.setOut(out);
            System.setErr(err);
        }
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(String conditionId) {
        this.conditionId = conditionId;
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(File buildFile) {
        this.buildFile = buildFile;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile, boolean append) {
        this.logFile = logFile;
        this.logFileAppend = append;
    }

    public List<String> getPropertyFiles() {
        return this.propertyFiles;
    }

    public void addPropertyFile(String propertyFile) {
        this.propertyFiles.add(propertyFile);
    }

    public void setPropertyFiles(List<String> propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public AntLogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(AntLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public Prompt.Type getSeverity() {
        return this.severity;
    }

    public void setSeverity(Prompt.Type severity) {
        this.severity = severity;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList<String> targets) {
        this.targets = targets;
    }

    public void addTarget(String target) {
        this.targets.add(target);
    }

    public List<String> getUninstallTargets() {
        return this.uninstallTargets;
    }

    public void setUninstallTargets(ArrayList<String> targets) {
        this.uninstallTargets = targets;
    }

    public void addUninstallTarget(String target) {
        this.uninstallTargets.add(target);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void addProperties(Project proj, Properties props) {
        if (proj == null) {
            return;
        }
        if (props.size() > 0) {
            for (Object o : props.keySet()) {
                String key = (String)o;
                proj.setProperty(key, props.getProperty(key));
            }
        }
    }

    private void addPropertiesFromPropertyFiles(Project proj) {
        if (proj == null) {
            return;
        }
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            for (String propertyFile : this.propertyFiles) {
                File file = new File(propertyFile);
                if (file.exists()) {
                    fis = new FileInputStream(file);
                    props.load(fis);
                    fis.close();
                    continue;
                }
                throw new IzPackException("Required propertyfile " + file + " for antcall doesn't exist.");
            }
        }
        catch (IOException exception) {
            throw new IzPackException(exception);
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
        this.addProperties(proj, props);
    }

    public void throwBuildException(IzPackException e) throws InstallerException {
        Throwable nested = e;
        IzPackException ize = e;
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            nested = cause;
        }
        if (nested instanceof BuildException) {
            Location location = ((BuildException)nested).getLocation();
            String message = nested.toString().substring(location.toString().length());
            ize = new IzPackException(message, e, this.severity);
        }
        throw new InstallerException(ize);
    }
}

