/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.regex;

import com.izforge.izpack.util.regex.RegexpMatcher;

public class RegexpMatcherFactory {
    public RegexpMatcher newRegexpMatcher() throws Exception {
        String systemDefault = System.getProperty("izpack.regexp.matcherimpl");
        if (systemDefault != null) {
            return this.createInstance(systemDefault);
        }
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createInstance("com.izforge.izpack.util.regex.JavaRegexpMatcher");
        }
        catch (Exception exception) {
            throw new Exception("No supported regular expression matcher found");
        }
    }

    protected RegexpMatcher createInstance(String className) throws RuntimeException {
        try {
            Class<?> implClass = Class.forName(className);
            return (RegexpMatcher)implClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected void testAvailability(String className) throws Exception {
        try {
            Class.forName(className);
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }
}

