/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class IoHelper {
    private static final String MASKED_SLASH_PLACEHOLDER = "~&_&~";

    public static File copyToTempFile(String template, String defaultExtension) throws IOException {
        return IoHelper.copyToTempFile(new File(template), defaultExtension);
    }

    public static File copyToTempFile(File templateFile, String defaultExtension) throws IOException {
        int pos;
        String path = templateFile.getCanonicalPath();
        String ext = path.substring(pos = path.lastIndexOf(46));
        if (ext.isEmpty()) {
            ext = defaultExtension;
        }
        File tmpFile = File.createTempFile("izpack_io", ext);
        tmpFile.deleteOnExit();
        FileUtils.copyFile(templateFile, tmpFile);
        return tmpFile;
    }

    public static long getFreeSpace(String path) {
        long ret = -1L;
        if (OsVersion.IS_WINDOWS) {
            String command = "cmd.exe";
            if (System.getProperty("os.name").toLowerCase().contains("windows 9")) {
                return -1L;
            }
            String[] params = new String[]{command, "/C", "\"dir /D /-C \"" + path + "\"\""};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            ret = IoHelper.extractLong(output[0], -3);
        } else if (OsVersion.IS_SUNOS) {
            String[] params = new String[]{"df", "-k", path};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            ret = IoHelper.extractLong(output[0], -3) * 1024L;
        } else if (OsVersion.IS_HPUX) {
            String[] params = new String[]{"bdf", path};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            ret = IoHelper.extractLong(output[0], -3) * 1024L;
        } else if (OsVersion.IS_UNIX) {
            String[] params = new String[]{"df", "-Pk", path};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            ret = IoHelper.extractLong(output[0], -3) * 1024L;
        }
        return ret;
    }

    public static boolean supported(String method) {
        if ("getFreeSpace".equals(method)) {
            if (OsVersion.IS_UNIX) {
                return true;
            }
            if (OsVersion.IS_WINDOWS) {
                return !System.getProperty("os.name").toLowerCase().contains("windows 9");
            }
        } else if ("chmod".equals(method)) {
            if (OsVersion.IS_UNIX) {
                return true;
            }
        } else {
            if ("copyFile".equals(method)) {
                return true;
            }
            if ("getPrimaryGroup".equals(method)) {
                if (OsVersion.IS_UNIX) {
                    return true;
                }
            } else {
                throw new RuntimeException("method name " + method + "not supported by this method");
            }
        }
        return false;
    }

    public static File existingParent(File path) {
        File result = path;
        while (!result.exists()) {
            if (result.getParent() == null) {
                return result;
            }
            result = result.getParentFile();
        }
        return result;
    }

    private static long extractLong(String in, int assumedPlace) {
        int i;
        long ret = -1L;
        StringTokenizer st = new StringTokenizer(in);
        int length = st.countTokens();
        int currentRange = 0;
        String[] interestedEntries = new String[6];
        for (i = 0; i < length - 3 + assumedPlace; ++i) {
            st.nextToken();
        }
        for (i = 0; i < 6; ++i) {
            if (!st.hasMoreTokens()) continue;
            interestedEntries[i] = st.nextToken();
            ++currentRange;
        }
        for (i = currentRange - 1; i >= 0; --i) {
            if (interestedEntries[i].contains("%")) continue;
            try {
                ret = Long.parseLong(interestedEntries[i]);
                break;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return ret;
    }

    private static String replaceString(String destination, String what, String with) {
        if (destination.contains(what)) {
            StringBuilder buf = new StringBuilder();
            int last = 0;
            int current = destination.indexOf(what);
            int whatLength = what.length();
            while (current >= 0) {
                if (current > 0) {
                    buf.append(destination.substring(last, current));
                }
                buf.append(with);
                last = current + whatLength;
                current = destination.indexOf(what, last);
            }
            if (destination.length() > last) {
                buf.append(destination.substring(last));
            }
            return buf.toString();
        }
        return destination;
    }

    public static String translatePath(String destination, Variables variables) {
        destination = variables.replace(destination);
        return IoHelper.translatePath(destination);
    }

    public static String translatePath(String destination) {
        if (destination.contains("\\/") && !destination.contains(MASKED_SLASH_PLACEHOLDER)) {
            destination = IoHelper.replaceString(destination, "\\/", MASKED_SLASH_PLACEHOLDER);
            destination = destination.replace('/', File.separatorChar);
            destination = IoHelper.replaceString(destination, MASKED_SLASH_PLACEHOLDER, "/");
        } else {
            destination = destination.replace('/', File.separatorChar);
        }
        return destination;
    }

    public static void copyStreamToJar(InputStream zin, ZipOutputStream out, String currentName, long fileTime) throws IOException {
        ZipEntry newEntry = new ZipEntry(currentName);
        if (fileTime != -1L) {
            newEntry.setTime(fileTime);
        }
        out.putNextEntry(newEntry);
        if (zin != null) {
            IOUtils.copy(zin, (OutputStream)out);
        }
        out.closeEntry();
    }
}

