/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.exception;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.resource.Messages;

public class WrappedNativeLibException
extends IzPackException {
    private static final long serialVersionUID = 8719330824802322745L;
    private final Messages messages;

    public WrappedNativeLibException(Throwable cause, Messages messages) {
        super(cause);
        this.messages = messages;
    }

    @Override
    public String getMessage() {
        if (this.getCause() instanceof NativeLibException) {
            String val;
            StringBuilder result = new StringBuilder();
            NativeLibException nle = (NativeLibException)this.getCause();
            if (nle.getLibMessage() != null) {
                val = this.messages.get("NativeLibException." + nle.getLibMessage(), new Object[0]);
                result.append(val);
            } else if (nle.getLibErr() != 0) {
                val = this.messages.get("NativeLibException.libErrNumber." + nle.getLibErr(), new Object[0]);
                result.append(val);
            }
            if (nle.getOsErr() != 0) {
                val = this.messages.get("NativeLibException.libInternal.OsErrNumPraefix", new Object[0]) + nle.getOsErr();
                if (result.length() != 0) {
                    result.append("\n");
                }
                result.append(val);
            }
            if (nle.getOsMessage() != null) {
                val = this.messages.get("NativeLibException.libInternal.OsErrStringPraefix", new Object[0]) + nle.getOsMessage();
                if (result.length() != 0) {
                    result.append("\n");
                }
                result.append(val);
            }
            if (result.length() > 0) {
                return nle.reviseMsgWithArgs(result.toString());
            }
            return nle.getMessage();
        }
        return super.getMessage();
    }
}

