/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.rules.CompareCondition;
import com.izforge.izpack.api.rules.ComparisonOperator;
import com.izforge.izpack.core.variable.utils.ValueUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;

public class CompareVersionsCondition
extends CompareCondition {
    private static final long serialVersionUID = 5605592864539142416L;
    private static final transient Logger logger = Logger.getLogger(CompareVersionsCondition.class.getName());
    private static final Set<String> EMPTY_STRINGS = Collections.singleton("");
    private static final String VERSION_DELIMITER = "[^\\d]+";
    protected static final int NOT_ASSUME_MISSING_MINOR_PARTS_AS_0 = 1;
    protected int flags = 0;

    public CompareVersionsCondition() {
        this(0);
    }

    public CompareVersionsCondition(int flags) {
        this.flags |= flags;
    }

    protected boolean hasFlag(int f) {
        return (this.flags & f) != 0;
    }

    @Override
    public boolean isTrue() {
        logger.fine("Version comparison: " + this.operand1 + " " + (Object)((Object)this.operator) + " " + this.operand2 + " (flags: " + this.flags + ")");
        boolean result = false;
        InstallData installData = this.getInstallData();
        if (installData != null && this.operand1 != null && this.operand2 != null) {
            Variables variables = installData.getVariables();
            String arg1 = variables.replace(this.operand1);
            String arg2 = variables.replace(this.operand2);
            if (this.operator == null) {
                this.operator = ComparisonOperator.EQUAL;
            }
            int res = 0;
            try {
                res = new Version(arg1).compareTo(new Version(arg2));
            }
            catch (IllegalArgumentException e) {
                logger.warning("[" + this.getClass().getSimpleName() + "] " + e.getMessage());
                return false;
            }
            logger.finer("Raw version comparison result: " + res);
            switch (this.operator) {
                case EQUAL: {
                    result = res == 0;
                    break;
                }
                case NOTEQUAL: {
                    result = res != 0;
                    break;
                }
                case GREATER: {
                    result = res > 0;
                    break;
                }
                case GREATEREQUAL: {
                    result = res >= 0;
                    break;
                }
                case LESS: {
                    result = res < 0;
                    break;
                }
                case LESSEQUAL: {
                    result = res <= 0;
                    break;
                }
            }
        }
        logger.fine(this.operand1 + " " + this.operator.getAttribute() + " " + this.operand2 + ": " + result);
        return result;
    }

    @Override
    public Set<String> getVarRefs() {
        return ValueUtils.parseUnresolvedVariableNames(this.operand1, this.operand2);
    }

    private class Version
    implements Comparable<Version> {
        private String version;

        public final String get() {
            return this.version;
        }

        public Version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Version can not be null");
            }
            if (!version.matches("[^\\d]*[\\d]+([^\\d]+[\\d]+)*[^\\d]*")) {
                throw new IllegalArgumentException("Invalid version format: '" + version + "'");
            }
            this.version = version;
        }

        @Override
        public int compareTo(Version version) {
            if (version == null) {
                return 1;
            }
            String[] parts1 = this.get().split(CompareVersionsCondition.VERSION_DELIMITER);
            ArrayList<String> leftOps = new ArrayList<String>(Arrays.asList(parts1));
            leftOps.removeAll(EMPTY_STRINGS);
            String[] parts2 = version.get().split(CompareVersionsCondition.VERSION_DELIMITER);
            ArrayList<String> rightOps = new ArrayList<String>(Arrays.asList(parts2));
            rightOps.removeAll(EMPTY_STRINGS);
            int length = CompareVersionsCondition.this.hasFlag(1) ? Math.min(leftOps.size(), rightOps.size()) : Math.max(leftOps.size(), rightOps.size());
            logger.finer("Effective number of version parts: " + length);
            for (int i = 0; i < length; ++i) {
                int part1 = i < leftOps.size() ? Integer.parseInt((String)leftOps.get(i)) : 0;
                int part2 = i < rightOps.size() ? Integer.parseInt((String)rightOps.get(i)) : 0;
                logger.finer("Compare version parts: " + part1 + " <-> " + part2);
                if (part1 < part2) {
                    return -1;
                }
                if (part1 <= part2) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(Object version) {
            if (this == version) {
                return true;
            }
            if (version == null) {
                return false;
            }
            if (this.getClass() != version.getClass()) {
                return false;
            }
            return this.compareTo((Version)version) == 0;
        }
    }
}

