/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.debugger;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.debugger.ConditionHistory;
import com.izforge.izpack.installer.debugger.ConditionHistoryTableCellRenderer;
import com.izforge.izpack.installer.debugger.ConditionHistoryTableModel;
import com.izforge.izpack.installer.debugger.DebugRowSorter;
import com.izforge.izpack.installer.debugger.VariableHistory;
import com.izforge.izpack.installer.debugger.VariableHistoryTableCellRenderer;
import com.izforge.izpack.installer.debugger.VariableHistoryTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class Debugger
extends WindowAdapter {
    private final Dimension DEFAULT_PANEL_SIZE = new Dimension(500, 500);
    private final InstallData idata;
    private final IconsDatabase icons;
    private final RulesEngine rules;
    private final Color buttonsHColor;
    private final VariableHistoryTableModel variablesmodel;
    private final ConditionHistoryTableModel conditionhistorymodel;
    private final Preferences preferences;
    private Properties lasttimevariables;

    public Debugger(InstallData installdata, IconsDatabase icons, RulesEngine rules, Color buttonsHColor) {
        this.idata = installdata;
        this.rules = rules;
        this.lasttimevariables = (Properties)this.idata.getVariables().getProperties().clone();
        this.icons = icons;
        this.buttonsHColor = buttonsHColor;
        this.variablesmodel = new VariableHistoryTableModel();
        this.conditionhistorymodel = new ConditionHistoryTableModel();
        this.preferences = Preferences.userNodeForPackage(Debugger.class);
        this.init();
    }

    private void init() {
        for (String variableName : this.lasttimevariables.stringPropertyNames()) {
            this.variablesmodel.setValue(variableName, this.lasttimevariables.getProperty(variableName), "initial value");
        }
        this.updateConditionsHistory("initial value");
    }

    private void debugVariables(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        this.getChangedVariables(nextpanelmetadata, lastpanelmetadata);
        this.lasttimevariables = (Properties)this.idata.getVariables().getProperties().clone();
    }

    private void debugConditions(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        this.conditionhistorymodel.clearState();
        this.updateConditionsHistory("changed after panel switch" + (lastpanelmetadata == null ? "" : " from " + lastpanelmetadata.getPanelId()) + " to " + nextpanelmetadata.getPanelId());
    }

    private void updateConditionsHistory(String comment) {
        for (String conditionid : this.rules.getKnownConditionIds()) {
            Condition condition = this.rules.getCondition(conditionid);
            this.conditionhistorymodel.setValue(condition, this.rules.isConditionTrue(condition), comment);
        }
        this.conditionhistorymodel.fireTableDataChanged();
    }

    private Properties getChangedVariables(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        Properties currentvariables = (Properties)this.idata.getVariables().getProperties().clone();
        Properties changedvariables = new Properties();
        this.variablesmodel.clearState();
        Enumeration<Object> currentvariableskeys = currentvariables.keys();
        boolean changes = false;
        while (currentvariableskeys.hasMoreElements()) {
            String key = (String)currentvariableskeys.nextElement();
            String currentvalue = currentvariables.getProperty(key);
            String oldvalue = this.lasttimevariables.getProperty(key);
            if (oldvalue == null) {
                this.variablesmodel.setValue(key, currentvalue, lastpanelmetadata != null ? "new after panel " + lastpanelmetadata.getPanelId() : "new on first panel ");
                changes = true;
                changedvariables.put(key, currentvalue);
                continue;
            }
            if (currentvalue.equals(oldvalue)) continue;
            this.variablesmodel.setValue(key, currentvalue, lastpanelmetadata != null ? "changed value after panel " + lastpanelmetadata.getPanelId() : "changed value on first panel ");
            changes = true;
            changedvariables.put(key, currentvalue);
        }
        if (changes) {
            this.variablesmodel.fireTableDataChanged();
        }
        return changedvariables;
    }

    private void modifyVariableManually(String name, String value) {
        this.lasttimevariables = (Properties)this.idata.getVariables().getProperties().clone();
        this.variablesmodel.setValue(name, value, "modified manually");
        this.variablesmodel.fireTableDataChanged();
        this.updateConditionsHistory("after manual modification of variable " + name);
    }

    private void removeVariableManually(String name) {
        this.lasttimevariables = (Properties)this.idata.getVariables().getProperties().clone();
        this.variablesmodel.removeValue(name, "removed manually");
        this.variablesmodel.fireTableDataChanged();
        this.updateConditionsHistory("after manual modification of variable " + name);
    }

    private static boolean isSet(String value) {
        return value != null && !value.isEmpty();
    }

    public JPanel getDebugPanel() {
        final JPanel debugpanel = new JPanel();
        debugpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        debugpanel.setLayout(new BorderLayout());
        final JTable variablestable = new JTable(this.variablesmodel);
        variablestable.setDefaultRenderer(VariableHistory.class, new VariableHistoryTableCellRenderer());
        variablestable.setSelectionMode(0);
        variablestable.setRowSelectionAllowed(true);
        variablestable.setRowSorter(new DebugRowSorter<VariableHistoryTableModel>(this.variablesmodel));
        JScrollPane scrollpane = new JScrollPane(variablestable);
        debugpanel.add((Component)scrollpane, "Center");
        JPanel varchangepanel = new JPanel(new BorderLayout());
        varchangepanel.setLayout(new BoxLayout(varchangepanel, 2));
        varchangepanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        final JTextField varname = new JTextField();
        varchangepanel.add(varname);
        JLabel label = new JLabel("=");
        varchangepanel.add(label);
        final JTextField varvalue = new JTextField();
        varchangepanel.add(varvalue);
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new BoxLayout(buttonpanel, 2));
        buttonpanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JButton changevarbtn = ButtonFactory.createButton(this.idata.getMessages().get("debug.changevariable", new Object[0]), (Icon)this.icons.get("debug.changevariable"), this.buttonsHColor);
        changevarbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String varnametxt = varname.getText();
                String varvaluetxt = varvalue.getText();
                if (Debugger.isSet(varnametxt) && varvaluetxt != null) {
                    Debugger.this.idata.setVariable(varnametxt, varvaluetxt);
                    Debugger.this.modifyVariableManually(varnametxt, varvaluetxt);
                    varname.setText("");
                    varvalue.setText("");
                }
            }
        });
        JButton deletebtn = ButtonFactory.createButton(this.idata.getMessages().get("debug.deletevariable", new Object[0]), (Icon)this.icons.get("debug.deletevariable"), this.buttonsHColor);
        deletebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String varnametxt = varname.getText();
                if (Debugger.isSet(varnametxt)) {
                    Debugger.this.idata.setVariable(varnametxt, null);
                    Debugger.this.removeVariableManually(varnametxt);
                    varname.setText("");
                    varvalue.setText("");
                }
            }
        });
        variablestable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedrow = variablestable.getRowSorter().convertRowIndexToModel(variablestable.getSelectedRow());
                VariableHistory variableHistory = (VariableHistory)Debugger.this.variablesmodel.getValueAt(selectedrow, 1);
                String selectedVariableName = variableHistory.getName();
                if (e.getClickCount() == 1) {
                    varname.setText(selectedVariableName);
                    varvalue.setText(variableHistory.getLastValue());
                } else {
                    JFrame variabledetails = new JFrame("Details");
                    JTextPane detailspane = new JTextPane();
                    detailspane.setContentType("text/html");
                    detailspane.setText(variableHistory.getValueHistoryDetails());
                    detailspane.setEditable(false);
                    JScrollPane scroller = new JScrollPane(detailspane);
                    Container container = variabledetails.getContentPane();
                    container.setLayout(new BorderLayout());
                    container.add((Component)scroller, "Center");
                    variabledetails.pack();
                    variabledetails.setLocationRelativeTo(debugpanel);
                    variabledetails.setVisible(true);
                }
            }
        });
        buttonpanel.add(changevarbtn);
        buttonpanel.add(deletebtn);
        JPanel editactionspanel = new JPanel();
        editactionspanel.setLayout(new BoxLayout(editactionspanel, 3));
        editactionspanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        editactionspanel.add(varchangepanel);
        editactionspanel.add(buttonpanel);
        debugpanel.add((Component)editactionspanel, "South");
        JPanel conditionpanel = new JPanel();
        conditionpanel.setLayout(new BorderLayout());
        conditionpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JTable conditiontable = new JTable(this.conditionhistorymodel);
        conditiontable.setDefaultRenderer(ConditionHistory.class, new ConditionHistoryTableCellRenderer());
        conditiontable.setSelectionMode(0);
        conditiontable.setRowSelectionAllowed(true);
        conditiontable.setRowSorter(new DebugRowSorter<ConditionHistoryTableModel>(this.conditionhistorymodel));
        conditiontable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedrow = conditiontable.getRowSorter().convertRowIndexToModel(conditiontable.getSelectedRow());
                ConditionHistory aConditionHistory = (ConditionHistory)conditiontable.getModel().getValueAt(selectedrow, 1);
                if (e.getClickCount() == 2) {
                    JFrame variabledetails = new JFrame("Details");
                    JTextPane detailspane = new JTextPane();
                    detailspane.setContentType("text/html");
                    detailspane.setText(aConditionHistory.getConditionHistoryDetails());
                    detailspane.setEditable(false);
                    JScrollPane scroller = new JScrollPane(detailspane);
                    Container container = variabledetails.getContentPane();
                    container.setLayout(new BorderLayout());
                    container.add((Component)scroller, "Center");
                    variabledetails.pack();
                    variabledetails.setLocationRelativeTo(debugpanel);
                    variabledetails.setVisible(true);
                }
            }
        });
        JScrollPane conditionscroller = new JScrollPane(conditiontable);
        conditionpanel.add((Component)conditionscroller, "Center");
        JTabbedPane tabpane = new JTabbedPane(1);
        tabpane.insertTab("Variable settings", null, debugpanel, "", 0);
        tabpane.insertTab("Condition settings", null, conditionpanel, "", 1);
        JPanel mainpanel = new JPanel();
        mainpanel.setLayout(new BorderLayout());
        mainpanel.add((Component)tabpane, "Center");
        return mainpanel;
    }

    public void switchPanel(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        this.debugVariables(nextpanelmetadata, lastpanelmetadata);
        this.debugConditions(nextpanelmetadata, lastpanelmetadata);
    }

    public void packSelectionChanged(String comment) {
        this.updateConditionsHistory(comment);
    }

    public JFrame initialize(JFrame targetFrame) {
        Dimension panelSize = this.getPanelSize();
        int defaultX = 0;
        int defaultY = 0;
        targetFrame.setLocation(this.preferences.getInt("x", defaultX), this.preferences.getInt("y", defaultY));
        targetFrame.setContentPane(this.getDebugPanel());
        targetFrame.addWindowListener(this);
        targetFrame.setSize(panelSize);
        targetFrame.setPreferredSize(panelSize);
        return targetFrame;
    }

    public Dimension getDefaultPanelSize() {
        return this.DEFAULT_PANEL_SIZE;
    }

    public Dimension getPanelSize() {
        return new Dimension(this.preferences.getInt("width", this.DEFAULT_PANEL_SIZE.width), this.preferences.getInt("height", this.DEFAULT_PANEL_SIZE.height));
    }

    public void storePositionAndSize(Component component) {
        this.preferences.putInt("x", component.getX());
        this.preferences.putInt("y", component.getY());
        this.preferences.putInt("width", component.getWidth());
        this.preferences.putInt("height", component.getHeight());
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.storePositionAndSize(e.getComponent());
    }
}

